/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Observable;
import java.util.Observer;

public class VolumeFader
extends Canvas {
    ObservableProxy observable;
    double value = 0.5;
    int thumbWidth = 8;
    Integer dragged = new Integer(0);
    Integer released = new Integer(1);

    public VolumeFader() {
        this.observable = new ObservableProxy();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                VolumeFader.this.handleMouseEvent(e, VolumeFader.this.released);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                VolumeFader.this.handleMouseEvent(e, VolumeFader.this.dragged);
            }
        });
        this.setSize(60, 16);
    }

    void handleMouseEvent(MouseEvent e, Object arg) {
        if (this.isEnabled()) {
            this.setValue(this.xToValue(e.getX()));
            this.observable.changed(arg);
        }
    }

    int valueToX(double value) {
        int width = this.bounds().width;
        int x1 = (int)((double)(width - this.thumbWidth) * value);
        return x1 + (this.thumbWidth >> 1);
    }

    double xToValue(int x) {
        int width = this.bounds().width;
        double vv = (double)(x - (this.thumbWidth >> 1)) / (double)(width - this.thumbWidth);
        return vv;
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observable.deleteObserver(o);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        if (val < 0.0) {
            val = 0.0;
        } else if (val > 1.0) {
            val = 1.0;
        }
        this.value = val;
        this.repaint();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.repaint();
    }

    public void fillBackground(Graphics g, int width, int height) {
        Color bgCol = this.getBackground();
        if (!this.isEnabled()) {
            bgCol = bgCol.darker();
        }
        g.setColor(bgCol);
        g.fillRect(0, 0, width, height);
    }

    public void drawBackground(Graphics g, int width, int height) {
        g.setColor(this.getForeground());
        g.drawRect(0, 0, --width, --height);
        int x1 = this.thumbWidth >> 1;
        int x2 = width - x1;
        g.drawLine(x1, height / 2, x2, 0);
        g.drawLine(x1, height / 2, x2, height);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        this.fillBackground(g, width, height);
        this.drawBackground(g, width, height);
        g.setColor(this.getForeground());
        int xp = this.valueToX(this.value);
        g.fillOval(xp - (this.thumbWidth >> 1), 0, this.thumbWidth, height);
    }

    class ObservableProxy
    extends Observable {
        ObservableProxy() {
        }

        void changed(Object arg) {
            if (!this.hasChanged()) {
                this.setChanged();
                this.notifyObservers(arg);
                this.clearChanged();
            }
        }
    }
}

