/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.tests;

import com.transjam.tests.FileProcessor;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;

public class FileModScanner
implements FileFilter {
    long threshold;
    Date date;
    File dirA;
    String dirNameAS;
    File dirB;
    String dirNameBS;
    String[] ignoreSuffices = new String[]{".class", ".obj"};

    @Override
    public boolean accept(File file) {
        boolean result = true;
        String name = file.getName();
        int i = 0;
        while (i < this.ignoreSuffices.length) {
            if (name.endsWith(this.ignoreSuffices[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    void setDate(Date date) {
        this.threshold = date.getTime();
        this.date = date;
    }

    private String getFixedName(File dir) {
        String dirName = dir.getAbsolutePath();
        String dirNameS = dirName.replace('\\', '/');
        if (dirNameS.charAt(dirNameS.length() - 1) != '/') {
            dirNameS = String.valueOf(dirNameS) + '/';
        }
        return dirNameS;
    }

    void setA(File dir) {
        this.dirA = dir;
        this.dirNameAS = this.getFixedName(dir);
    }

    void setB(File dir) {
        this.dirB = dir;
        this.dirNameBS = this.getFixedName(dir);
    }

    File mapFileAtoB(File fileA) {
        String fileNameA = fileA.getAbsolutePath();
        String fileNameAS = fileNameA.replace('\\', '/');
        String fileNameBS = fileNameAS.replaceFirst(this.dirNameAS, this.dirNameBS);
        String fileNameB = fileNameBS.replace('/', '\\');
        return new File(fileNameB);
    }

    private void scanDirectory(File dir, FileProcessor proc) {
        File[] list = dir.listFiles(this);
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File next = list[i];
                if (next.isDirectory()) {
                    this.scanDirectory(next, proc);
                } else {
                    proc.processFile(next);
                }
                ++i;
            }
        }
    }

    void scanAfter(File dir) {
        FileProcessor proc = new FileProcessor(){

            @Override
            public void processFile(File file) {
                if (file.lastModified() > FileModScanner.this.threshold) {
                    FileModScanner.this.printFile(file);
                }
            }
        };
        this.scanDirectory(dir, proc);
    }

    void scanAB() {
        FileProcessor proc = new FileProcessor(){

            @Override
            public void processFile(File fileA) {
                File fileB = FileModScanner.this.mapFileAtoB(fileA);
                if (fileB.exists()) {
                    long modB;
                    long modA = fileA.lastModified();
                    if (modA > (modB = fileB.lastModified())) {
                        System.out.print(">>>>A : ");
                        FileModScanner.this.printFile(fileA);
                        System.out.print("<<<<B : ");
                        FileModScanner.this.printFile(fileB);
                    } else if (modA < modB) {
                        System.out.print("----A : ");
                        FileModScanner.this.printFile(fileA);
                        System.out.print("====B : ");
                        FileModScanner.this.printFile(fileB);
                    }
                } else {
                    System.out.print("New : ");
                    FileModScanner.this.printFile(fileA);
                }
            }
        };
        this.scanDirectory(this.dirA, proc);
    }

    void printFile(File file) {
        Date modDate = new Date(file.lastModified());
        System.out.println(modDate + " : " + file);
    }

    public static void main(String[] args) {
        FileModScanner scanner = new FileModScanner();
        File dirA = new File("E:\\nomad\\MIDISynth_050313\\code");
        scanner.setA(dirA);
        File dirB = new File("E:\\nomad\\MIDISynth\\code");
        scanner.setB(dirB);
        scanner.scanAB();
        System.out.println("------------ Scan complete. -------------");
    }
}

