/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.XMLTools;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;

public class XMLWriter
extends PrintWriter {
    Stack tagStack = new Stack();
    static final int AT_TOP = 0;
    static final int IN_TAG = 1;
    static final int IN_ELEMENT = 2;
    private int state = 0;

    public XMLWriter(OutputStream stream) {
        super(stream);
    }

    public void writeAttribute(String name, String value) {
        if (this.state != 1) {
            this.print("<ILLEGAL ATTRIBUTE IN ELEMENT>");
        } else {
            this.print(" " + name + "=\"" + value + "\"");
        }
    }

    public void writeAttribute(String name, int value) {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, long value) {
        this.writeAttribute(name, Long.toString(value));
    }

    public void writeAttribute(String name, double value) {
        this.writeAttribute(name, Double.toString(value));
    }

    public void begin() {
        this.println("<?xml version=\"1.0\"?>");
        this.state = 0;
    }

    public void end() {
        if (this.state != 0) {
            throw new RuntimeException("XMLWriter element not terminated.");
        }
        this.flush();
    }

    public void beginElement(String name) {
        this.tagStack.push(name);
        switch (this.state) {
            case 1: {
                this.println(">");
            }
        }
        this.print("<" + name);
        this.state = 1;
    }

    public void endElement() {
        String elementName = (String)this.tagStack.pop();
        switch (this.state) {
            case 1: {
                this.println("/>");
                break;
            }
            case 2: {
                this.println("</" + elementName + ">");
            }
        }
        this.state = this.tagStack.isEmpty() ? 0 : 2;
    }

    public void writeContent(String content) {
        switch (this.state) {
            case 1: {
                this.print(">");
            }
        }
        this.print(XMLTools.escapeText(content));
        this.state = 2;
    }

    public void writeComment(String text) {
        this.beginElement("comment");
        this.writeContent(text);
        this.endElement();
    }

    void test1() {
        this.begin();
        this.beginElement("bigdoc");
        this.writeAttribute("name", "foo");
        this.writeComment("This is a comment with problem characters like < , > and & !!");
        this.beginElement("nested");
        this.writeAttribute("x", 100);
        this.writeAttribute("y", 500);
        this.endElement();
        this.beginElement("frequency");
        this.writeAttribute("port", 7);
        this.writeContent("123.456");
        this.endElement();
        this.endElement();
        this.end();
    }

    public static void main(String[] args) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLWriter writer = new XMLWriter(outStream);
        writer.test1();
        writer.flush();
        System.out.println("-----------------");
        System.out.println(outStream);
    }
}

