/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.webdrum;

import com.transjam.awt.AppletTester;
import com.transjam.awt.ChatPanel;
import com.transjam.awt.ClientLoginManager;
import com.transjam.awt.ContainerHack;
import com.transjam.awt.ModelProxyDelegate;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import com.transjam.client.ModelProxy;
import com.transjam.drumbox.DrumBox;
import com.transjam.drumbox.SongDelegate;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.TrackDelegate;
import com.transjam.drumbox.TrackModel;
import com.transjam.util.DebugLog;
import com.transjam.webdrum.WebSongProxy;
import com.transjam.webdrum.WebTrackProxy;
import java.applet.Applet;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class WebDrum
extends Applet {
    private ClientLoginManager helper;
    private static String DEFAULT_OPTIONS = "usc";
    Client client;
    ClientAdapter clientAdapter;
    private Frame chatFrame;
    Button showChatButton;
    ChatPanel chatPanel;
    Button hangButton;
    DrumBox drumBox;
    String hostName = null;
    boolean drumBoxStarted = false;
    Vector proxies;
    private boolean isApplet = true;
    Panel applicationPanel;
    static final int MAX_CLIENTS_PER_ROOM = 6;

    @Override
    public void start() {
        this.setLayout(new FlowLayout());
        this.helper = new ClientLoginManager();
        this.client = this.helper.connect(this, "webdrum2", 6);
        if (this.client == null) {
            this.add(new Label("Connection to server failed! Please try again later."));
        } else {
            this.clientAdapter = new WebDrumClientAdapter();
            this.client.addMessageListener(this.clientAdapter, 2);
            this.drumBox = this.isApplet ? new DrumBox(this) : new DrumBox(null);
            this.setupChat();
            this.setupDrumProxies();
            this.helper.login();
            this.applicationPanel = new Panel();
            this.applicationPanel.setLayout(new GridLayout(0, 1));
            this.applicationPanel.add(new Label("WebDrum Windows", 1));
            this.applicationPanel.add(this.showChatButton);
            this.applicationPanel.add(this.drumBox);
        }
        this.getParent().validate();
        this.getParent().repaint();
    }

    void setupChat() {
        this.chatFrame = new Frame("WebDrum Chat by SoftSynth.com");
        this.chatFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WebDrum.this.chatFrame.hide();
            }
        });
        this.chatFrame.setSize(600, 400);
        this.chatPanel = new ChatPanel(this.client);
        this.chatFrame.add(this.chatPanel);
        this.chatPanel.start();
        this.showChatButton = new Button("Show Chat Window");
        this.showChatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDrum.this.chatFrame.show();
            }
        });
    }

    void setupDrumProxies() {
        try {
            this.proxies = new Vector();
            SongModel songModel = this.drumBox.getSongModel();
            SongDelegate songDelegate = this.drumBox.getSongDelegate();
            int i = 0;
            while (i < songModel.getNumTracks()) {
                TrackModel trackModel = songModel.getTrack(i);
                TrackDelegate trackDelegate = songDelegate.getTrack(i);
                WebTrackProxy proxy = new WebTrackProxy(this.client, trackModel, "tr" + i);
                this.proxies.addElement(proxy);
                Panel miscPanel = trackDelegate.getMiscPanel();
                ((FlowLayout)miscPanel.getLayout()).setVgap(0);
                miscPanel.add(new ModelProxyDelegate(trackDelegate, proxy));
                ++i;
            }
            WebSongProxy songProxy = new WebSongProxy(this.client, songModel, "song");
            this.proxies.addElement(songProxy);
            songDelegate.getControlPanel().add(new ModelProxyDelegate(songDelegate, songProxy));
        }
        catch (IOException exc) {
            this.add(new Label("Caught: " + exc));
            System.err.println("Caught: " + exc);
            exc.printStackTrace(System.err);
        }
    }

    void hideApplication() {
        this.remove(this.applicationPanel);
        this.chatFrame.hide();
        this.drumBox.hide();
    }

    void showApplication() {
        if (!this.isAncestorOf(this.applicationPanel)) {
            this.add(this.applicationPanel);
            ContainerHack.syncContainer(this.applicationPanel);
        }
        this.chatFrame.show();
        this.drumBox.show();
    }

    void startDrumBox() throws IOException {
        if (this.drumBoxStarted) {
            return;
        }
        DebugLog.debugln(120, "startDrumBox: enter");
        this.drumBox.start();
        DebugLog.debugln(120, "startDrumBox: start proxies");
        Enumeration enumer = this.proxies.elements();
        while (enumer.hasMoreElements()) {
            ModelProxy proxy = (ModelProxy)enumer.nextElement();
            proxy.start();
        }
        DebugLog.debugln(120, "startDrumBox: request lists");
        this.client.requestUserList();
        this.client.requestThingList();
        this.client.sendSelf("showdrum");
        this.drumBox.setEnabled(true);
        DebugLog.debugln(120, "startDrumBox: exit");
        this.drumBoxStarted = true;
    }

    void stopDrumBox() throws IOException {
        if (!this.drumBoxStarted) {
            return;
        }
        Enumeration enumer = this.proxies.elements();
        while (enumer.hasMoreElements()) {
            ModelProxy proxy = (ModelProxy)enumer.nextElement();
            proxy.stop();
        }
        this.drumBox.stop();
        this.drumBox.setEnabled(false);
        this.drumBoxStarted = false;
    }

    @Override
    public void stop() {
        try {
            this.stopDrumBox();
            if (this.drumBox != null) {
                this.drumBox.term();
            }
            if (this.chatPanel != null) {
                this.chatPanel.stop();
            }
            if (this.chatFrame != null) {
                this.chatFrame.hide();
            }
        }
        catch (IOException ioe) {
            System.err.println("Applet stop() caught " + ioe);
            ioe.printStackTrace();
        }
        this.helper.logout();
        this.removeAll();
    }

    public static void main(String[] argv) {
        WebDrum applet = new WebDrum();
        applet.isApplet = false;
        DebugLog.setOptions(DEFAULT_OPTIONS);
        AppletTester.test(applet, 600, 440);
    }

    class WebDrumClientAdapter
    extends ClientAdapter {
        WebDrumClientAdapter() {
        }

        @Override
        public void enteredRoom(String name, int level) throws IOException {
            WebDrum.this.startDrumBox();
            WebDrum.this.showApplication();
        }

        @Override
        public void exitedRoom(String name, int level) throws IOException {
            WebDrum.this.hideApplication();
            WebDrum.this.stopDrumBox();
        }

        @Override
        public void sentSelf(String text) {
            if (text.equals("showdrum")) {
                WebDrum.this.drumBox.hide();
                WebDrum.this.drumBox.show();
            }
        }

        @Override
        public void serverDown(Client client) {
            if (WebDrum.this.drumBoxStarted) {
                WebDrum.this.chatPanel.getAttention();
                WebDrum.this.chatPanel.appendSystem("SERVER DISCONNECTED!!");
            }
        }
    }
}

