/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import compmus.Melody;
import compmus.MelodyPlayer;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;

public class LinearTranspose
extends Applet
implements Tweakable {
    LineOut myOut;
    MelodyPlayer player;
    private static final int DE = 2;
    private static final int DED = 3;
    private static final int DQ = 4;
    private static final int DQD = 6;
    private static final int DH = 8;
    private static final int DHD = 12;
    int[] pitches;
    int[] durations;
    Melody melody;
    static final EqualTemperedTuning tuning = new EqualTemperedTuning(200.0);
    double freqScalar;
    double freqAdder;
    LabelledFader multiplyFader;
    LabelledFader addFader;
    Button resetButton;
    volatile boolean go;

    public LinearTranspose() {
        int[] nArray = new int[45];
        nArray[0] = 4;
        nArray[1] = 2;
        nArray[3] = 4;
        nArray[4] = 2;
        nArray[6] = 7;
        nArray[7] = 5;
        nArray[8] = 5;
        nArray[9] = 4;
        nArray[10] = 7;
        nArray[11] = 5;
        nArray[12] = 5;
        nArray[13] = 4;
        nArray[14] = 7;
        nArray[15] = 12;
        nArray[16] = 12;
        nArray[17] = 11;
        nArray[18] = 9;
        nArray[19] = 11;
        nArray[20] = 12;
        nArray[21] = 7;
        nArray[22] = 7;
        nArray[23] = 7;
        nArray[24] = 12;
        nArray[25] = 12;
        nArray[26] = 12;
        nArray[27] = 11;
        nArray[28] = 9;
        nArray[29] = 11;
        nArray[30] = 12;
        nArray[31] = 7;
        nArray[32] = 7;
        nArray[33] = 7;
        nArray[34] = 7;
        nArray[35] = 12;
        nArray[36] = 12;
        nArray[37] = 11;
        nArray[38] = 9;
        nArray[39] = 11;
        nArray[40] = 12;
        nArray[41] = 7;
        nArray[42] = 7;
        nArray[43] = 7;
        nArray[44] = 5;
        this.pitches = nArray;
        this.durations = new int[]{6, 6, 12, 6, 6, 12, 6, 4, 2, 12, 6, 4, 2, 12, 2, 4, 2, 2, 2, 2, 4, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 4, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2};
        this.freqScalar = 1.0;
        this.freqAdder = 0.0;
        this.go = false;
    }

    public static void main(String[] args) {
        LinearTranspose applet = new LinearTranspose();
        AppletFrame frame = new AppletFrame("Transpose: freq' = A*freq + B", applet);
        frame.resize(600, 120);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.player = new MelodyPlayer(){

                @Override
                double pitchToFreq(int pitch) {
                    return super.pitchToFreq(pitch) * LinearTranspose.this.freqScalar + LinearTranspose.this.freqAdder;
                }
            };
            this.melody = new Melody(this.pitches.length, this.pitches, this.durations);
            this.player.setMelody(this.melody);
            this.player.setLoop(true);
            this.player.setSecondsPerUnitDuration(0.07);
            this.myOut = new LineOut();
            this.player.getOutput().connect(0, this.myOut.input, 0);
            this.player.getOutput().connect(0, this.myOut.input, 1);
            this.myOut.start();
            this.setLayout(new GridLayout(0, 1));
            this.multiplyFader = new LabelledFader(this, 1, "Multiply by (A)", 1.0, 0.25, 4.0);
            this.add(this.multiplyFader);
            this.addFader = new LabelledFader(this, 2, "Add (B)", 0.0, -50.0, 400.0);
            this.add(this.addFader);
            this.resetButton = new Button("Reset Transposition");
            this.add(this.resetButton);
            this.getParent().validate();
            this.getToolkit().sync();
            this.player.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.player.stop();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 1: {
                this.freqScalar = val;
                break;
            }
            case 2: {
                this.freqAdder = val;
            }
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.resetButton) {
            this.multiplyFader.setValue(1.0);
            this.addFader.setValue(0.0);
            Runtime.getRuntime().gc();
            return true;
        }
        return false;
    }
}

