/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import com.softsynth.jsyn.view11x.LabelledFader;
import com.softsynth.jsyn.view11x.SynthScope;
import com.softsynth.jsyn.view11x.Tweakable;
import compmus.Cuber;
import compmus.PitchedVoices;
import compmus.PolyKeyPlayer;
import compmus.SineEnv;
import compmus.SoftClip1;
import compmus.SoftClip2;
import compmus.Squarer;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PlayShaperFormulae
extends Applet
implements Tweakable {
    static final int MAX_NOTES = 4;
    static final int NUM_SHAPERS = 4;
    int is;
    String keys;
    PitchedVoices ringVoices;
    LineOut lineOut;
    Squarer squarer;
    Cuber cuber;
    SoftClip1 clipper1;
    SoftClip2 clipper2;
    SynthInput[] inputs;
    SynthOutput[] outputs;
    boolean[] enables;
    double[] septatonic;
    BussedVoiceAllocator voiceAllocator;
    PolyKeyPlayer keyPlayer;
    SynthCircuit shaper;
    MultiplyUnit gain;
    AddUnit connector;
    ExponentialLag gainLag;
    LabelledFader ampFader;
    SynthScope scope;
    Button keyButton;
    Checkbox nullBox;
    Checkbox cuberBox;
    Checkbox squarerBox;
    Checkbox clipper1Box;
    Checkbox clipper2Box;
    double[] septatonicOctave = new double[]{1.0, 1.125, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667, 1.7777777777777777};

    public static void main(String[] args) {
        PlayShaperFormulae applet = new PlayShaperFormulae();
        AppletFrame frame = new AppletFrame("Play WaveShaping Formulae.", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    double[] buildScale(int numNotes, double fundamental, double[] scale) {
        double[] freqs = new double[numNotes];
        int i = 0;
        while (i < numNotes) {
            int octave = i / scale.length;
            int pitch = i % scale.length;
            freqs[i] = scale[pitch] * fundamental * (double)(1 << octave);
            ++i;
        }
        return freqs;
    }

    void connectShapers() {
        SynthOutput lastOutput = this.gain.output;
        int i = 0;
        while (i < 4) {
            if (this.enables[i]) {
                lastOutput.connect(this.inputs[i]);
                lastOutput = this.outputs[i];
            }
            ++i;
        }
        lastOutput.connect(this.connector.inputA);
    }

    void enableShaper(int index, boolean enabled) {
        this.enables[index] = enabled;
        this.keyButton.requestFocus();
        this.connectShapers();
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 0: {
                this.gainLag.input.set(val);
            }
        }
        this.keyButton.requestFocus();
    }

    void setupGUI() {
        this.setLayout(new GridLayout(0, 1));
        Panel controlPanel = new Panel();
        controlPanel.setLayout(new GridLayout(0, 1));
        this.add(controlPanel);
        this.keyButton = new Button("Play Keys: " + this.keys);
        controlPanel.add(this.keyButton);
        this.keyButton.addKeyListener(this.keyPlayer);
        this.addKeyListener(this.keyPlayer);
        this.ampFader = new LabelledFader(this, 0, "Amplitude", 0.5, 0.1, 5.0);
        controlPanel.add(this.ampFader);
        this.ampFader.getFader().setTaper(1);
        this.squarerBox = new Checkbox("y = x^2");
        controlPanel.add(this.squarerBox);
        this.squarerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayShaperFormulae.this.enableShaper(0, PlayShaperFormulae.this.squarerBox.getState());
            }
        });
        this.cuberBox = new Checkbox("y = x^3");
        controlPanel.add(this.cuberBox);
        this.cuberBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayShaperFormulae.this.enableShaper(1, PlayShaperFormulae.this.cuberBox.getState());
            }
        });
        this.clipper2Box = new Checkbox("y = 1.5x - 0.5x^3");
        controlPanel.add(this.clipper2Box);
        this.clipper2Box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayShaperFormulae.this.enableShaper(2, PlayShaperFormulae.this.clipper2Box.getState());
            }
        });
        this.clipper1Box = new Checkbox("y = x / (1 + |x|)");
        controlPanel.add(this.clipper1Box);
        this.clipper1Box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayShaperFormulae.this.enableShaper(3, PlayShaperFormulae.this.clipper1Box.getState());
            }
        });
        this.scope = new SynthScope();
        this.scope.createProbe(this.gain.output, "original", Color.yellow);
        this.scope.createProbe(this.connector.output, "shaped", Color.cyan);
        this.scope.finish();
        this.scope.hideControls();
        this.add(this.scope);
        this.keyButton.requestFocus();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void setupSynth() {
        this.keyPlayer = new PolyKeyPlayer();
        this.keys = "zxcvbnmasdfghjqwertyu1234567890";
        this.keyPlayer.setKeys(this.keys);
        this.septatonic = this.buildScale(this.keys.length(), 200.0, this.septatonicOctave);
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.voiceAllocator = new BussedVoiceAllocator(4){

                @Override
                public SynthCircuit makeVoice() throws SynthException {
                    SineEnv circ = new SineEnv();
                    return this.addVoiceToMix(circ);
                }
            };
            this.ringVoices = new PitchedVoices(this.voiceAllocator, this.septatonic);
            this.keyPlayer.setVoices(this.ringVoices);
            this.keyPlayer.setAmplitude(1.0);
            this.inputs = new SynthInput[4];
            this.outputs = new SynthOutput[4];
            this.enables = new boolean[4];
            this.gain = new MultiplyUnit();
            this.gainLag = new ExponentialLag();
            this.is = 0;
            this.squarer = new Squarer();
            this.inputs[this.is] = this.squarer.input;
            this.outputs[this.is++] = this.squarer.output;
            this.cuber = new Cuber();
            this.inputs[this.is] = this.cuber.input;
            this.outputs[this.is++] = this.cuber.output;
            this.clipper2 = new SoftClip2();
            this.inputs[this.is] = this.clipper2.input;
            this.outputs[this.is++] = this.clipper2.output;
            this.clipper1 = new SoftClip1();
            this.inputs[this.is] = this.clipper1.input;
            this.outputs[this.is++] = this.clipper1.output;
            this.connector = new AddUnit();
            this.lineOut = new LineOut();
            this.voiceAllocator.output.connect(this.gain.inputA);
            this.gainLag.output.connect(this.gain.inputB);
            this.connectShapers();
            this.connector.output.connect(0, this.lineOut.input, 0);
            this.connector.output.connect(0, this.lineOut.input, 1);
            this.gainLag.start();
            this.gain.start();
            this.squarer.start();
            this.cuber.start();
            this.clipper2.start();
            this.clipper1.start();
            this.connector.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void start() {
        this.setupSynth();
        this.setupGUI();
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.voiceAllocator.stop();
        this.voiceAllocator.delete();
        this.voiceAllocator = null;
        this.removeAll();
        Synth.verbosity = 0;
        Synth.stopEngine();
    }
}

