/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import compmus.SampleOverview;
import compmus.ScrubbingCircuit;
import java.awt.Event;

class ScrubberController
extends SampleOverview
implements Runnable {
    ScrubbingCircuit scrubCircuit;
    Thread thread;
    volatile boolean go = false;

    public ScrubberController(ScrubbingCircuit scrubCircuit) {
        this.scrubCircuit = scrubCircuit;
    }

    void showPosition() {
        if (this.data != null) {
            int index = (int)((double)this.data.length * (0.5 * (this.scrubCircuit.getPosition() + 1.0)));
            this.setCursorIndex(index);
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.go = true;
            this.thread.start();
        }
    }

    public void stop() {
        this.go = false;
        this.thread = null;
    }

    @Override
    public void run() {
        while (this.go) {
            try {
                Thread.sleep(66L);
            }
            catch (InterruptedException e) {
                break;
            }
            this.showPosition();
        }
    }

    @Override
    public boolean mouseDown(Event evt, int x, int y) {
        double wx = (double)x / (double)this.size().width;
        double wy = (double)y / (double)this.size().height;
        this.scrubCircuit.down(wx, wy);
        return true;
    }

    @Override
    public boolean mouseDrag(Event evt, int x, int y) {
        double wx = (double)x / (double)this.size().width;
        double wy = (double)y / (double)this.size().height;
        this.scrubCircuit.drag(wx, wy);
        return true;
    }

    @Override
    public boolean mouseUp(Event evt, int x, int y) {
        double wx = (double)x / (double)this.size().width;
        double wy = (double)y / (double)this.size().height;
        this.scrubCircuit.up(wx, wy);
        return true;
    }
}

