/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.PeakFollower;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthBusOutput;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthSample;

public class VariableMultiTap {
    private SampleReader_16V1 sampleReader;
    private PeakFollower follower;
    private BusWriter busWriter;
    private SynthSample delayLine;
    private int startOffset;
    private int targetDelayInFrames;
    private int actualDelayInFrames;
    private double framePeriod;
    public SynthBusOutput busOutput;

    public VariableMultiTap(SynthCircuit circ, SynthSample delayLine) {
        this.delayLine = delayLine;
        this.framePeriod = 1.0 / Synth.getFrameRate();
        this.sampleReader = new SampleReader_16V1();
        circ.add(this.sampleReader);
        this.follower = new PeakFollower();
        circ.add(this.follower);
        this.busWriter = new BusWriter();
        circ.add(this.busWriter);
        this.sampleReader.output.connect(this.busWriter.input);
        this.sampleReader.output.connect(this.follower.input);
        this.busOutput = this.busWriter.busOutput;
        int numSamples = delayLine.getNumFrames();
        this.startOffset = numSamples - 30;
        this.sampleReader.samplePort.queue(delayLine, 30, this.startOffset);
        this.sampleReader.samplePort.queueLoop(delayLine, 0, numSamples);
    }

    protected double getDelay() {
        return (double)this.actualDelayInFrames * this.framePeriod;
    }

    void setAmplitude(double amp) {
        this.sampleReader.amplitude.set(amp);
    }

    double getAmplitude() {
        return this.sampleReader.amplitude.get();
    }

    double getPeakVolume() {
        return this.follower.output.get();
    }

    protected int chase(int framesWritten) {
        int framesRead = this.sampleReader.samplePort.getNumFramesMoved();
        this.actualDelayInFrames = framesWritten - (framesRead - this.startOffset);
        double rateScaler = (double)this.actualDelayInFrames / (double)this.targetDelayInFrames;
        double adjustedRate = Synth.getFrameRate() * rateScaler;
        this.sampleReader.rate.set(adjustedRate);
        return this.actualDelayInFrames;
    }

    public int getTargetDelayInFrames() {
        return this.targetDelayInFrames;
    }

    public double getTargetDelayInSeconds() {
        return (double)this.targetDelayInFrames * this.framePeriod;
    }

    public void setTargetDelayInFrames(int n) {
        this.targetDelayInFrames = n;
    }

    public void setTargetDelayInSeconds(double seconds) {
        this.targetDelayInFrames = (int)(seconds * Synth.getFrameRate());
    }
}

