/*
 * Decompiled with CFR 0.152.
 */
package usertest.paul;

import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.util.SampleQueueInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class TestJSandJSYN {
    boolean doRead = true;
    boolean overrideValue = false;
    boolean doTestSleep = true;
    int framesPerRead = 512;
    int sampleQueueSize;
    int lineOutBufferSize = this.sampleQueueSize = this.framesPerRead * 32;
    int nChannel = 2;
    int sampSizeInBits = 16;
    Note note;
    SampleWriter_16F2 writer;
    SampleQueueInputStream inStream;
    SineOscillator sin;
    SourceDataLine line = null;

    public TestJSandJSYN() {
        Synth.requestVersion(141);
        Synth.startEngine(4, 44100.0);
        this.note = new Note();
        MyRunner t = new MyRunner();
        t.start();
        if (this.doTestSleep) {
            long tnow = System.currentTimeMillis();
            int i = 0;
            while (i < 100000) {
                Synth.sleepUntilTick(1000 * i);
                long tlast = tnow;
                tnow = System.currentTimeMillis();
                System.out.println(tnow - tlast);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        new TestJSandJSYN();
    }

    class MyRunner
    extends Thread {
        MyRunner() {
        }

        @Override
        public void run() {
            int bytesPerFrame = TestJSandJSYN.this.framesPerRead * 4;
            int nShort = TestJSandJSYN.this.framesPerRead * 2;
            try {
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, new AudioFormat(44100.0f, TestJSandJSYN.this.sampSizeInBits, TestJSandJSYN.this.nChannel, true, false), TestJSandJSYN.this.lineOutBufferSize);
                TestJSandJSYN.this.line = (SourceDataLine)AudioSystem.getLine(info);
                TestJSandJSYN.this.line.open();
                System.out.println("line BufferSize = " + TestJSandJSYN.this.line.getBufferSize());
                short[] sbuff = new short[TestJSandJSYN.this.framesPerRead * TestJSandJSYN.this.nChannel];
                byte[] buffer = new byte[TestJSandJSYN.this.framesPerRead * TestJSandJSYN.this.nChannel * 2];
                boolean started = false;
                int count = 0;
                while (true) {
                    int n;
                    int i;
                    if (TestJSandJSYN.this.inStream.getOverflowed()) {
                        System.err.println(" OVERFLOW ");
                        System.exit(-1);
                    }
                    if (TestJSandJSYN.this.doRead) {
                        int nread = TestJSandJSYN.this.inStream.read(sbuff, 0, TestJSandJSYN.this.framesPerRead);
                        this.assertX(nread == TestJSandJSYN.this.framesPerRead);
                    }
                    if (TestJSandJSYN.this.overrideValue) {
                        i = 0;
                        while (i < TestJSandJSYN.this.framesPerRead) {
                            short val;
                            short s = val = (short)(32000.0 * Math.sin(1256.6370614359173 * (double)count++ / 44100.0));
                            sbuff[2 * i + 1] = s;
                            sbuff[2 * i] = s;
                            count %= 88200;
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < nShort) {
                        buffer[2 * i] = (byte)(sbuff[i] & 0xFF);
                        buffer[2 * i + 1] = (byte)((sbuff[i] & 0xFF00) >> 8);
                        ++i;
                    }
                    if (!started) {
                        TestJSandJSYN.this.line.start();
                        started = true;
                    }
                    this.assertX((n = TestJSandJSYN.this.line.write(buffer, 0, nShort * 2)) == nShort * 2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        private void assertX(boolean b) {
            if (!b) {
                throw new RuntimeException("Assertion failed");
            }
        }
    }

    class Note
    extends SynthNote {
        Note() {
            TestJSandJSYN.this.sin = new SineOscillator();
            this.add(TestJSandJSYN.this.sin);
            TestJSandJSYN.this.sin.frequency.set(0, 200.0);
            TestJSandJSYN.this.sin.amplitude.set(0, 0.9);
            this.output = TestJSandJSYN.this.sin.output;
            this.addPort(this.output);
            TestJSandJSYN.this.writer = new SampleWriter_16F2();
            this.add(TestJSandJSYN.this.writer);
            TestJSandJSYN.this.writer.input.connect(0, TestJSandJSYN.this.sin.output, 0);
            TestJSandJSYN.this.writer.input.connect(1, TestJSandJSYN.this.sin.output, 0);
            this.start();
            TestJSandJSYN.this.inStream = new SampleQueueInputStream(TestJSandJSYN.this.writer.samplePort, TestJSandJSYN.this.sampleQueueSize, 2);
            TestJSandJSYN.this.inStream.start(0);
        }
    }
}

