/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.TriangleOscillator;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TJ_Tracking
extends Applet {
    Button runButton;
    Button collectButton;
    Button deleteButton;
    Checkbox trackingCheckbox;

    public static void main(String[] args) {
        TJ_Tracking applet = new TJ_Tracking();
        AppletFrame frame = new AppletFrame("Test Object Tracking", applet);
        frame.resize(440, 200);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.runButton = new Button("Run Test");
            this.add(this.runButton);
            this.runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Tracking.this.test();
                }
            });
            this.collectButton = new Button("Garbage Collect");
            this.add(this.collectButton);
            this.collectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Runtime.getRuntime().gc();
                }
            });
            this.trackingCheckbox = new Checkbox("Track New Units");
            this.add(this.trackingCheckbox);
            this.trackingCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SynthObject.enableTracking(e.getStateChange() == 1);
                }
            });
            this.deleteButton = new Button("Delete All");
            this.add(this.deleteButton);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SynthObject.deleteAll();
                }
            });
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        Synth.stopEngine();
    }

    void test() {
        TestCircuit circ = new TestCircuit(Math.random() * 300.0 + 200.0);
        circ.start();
    }

    class TestCircuit
    extends SynthCircuit {
        TriangleOscillator triOsc = new TriangleOscillator();
        LineOut lineOut;

        public TestCircuit(double frequency) throws SynthException {
            this.add(this.triOsc);
            this.lineOut = new LineOut();
            this.add(this.lineOut);
            this.triOsc.amplitude.set(0.2);
            this.triOsc.frequency.set(frequency);
            this.triOsc.output.connect(this.lineOut.input);
        }
    }
}

