/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.debug;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.unitgen.VariableRateStereoReader;
import com.jsyn.util.SampleLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DebugSamplerDistortion {
    private Synthesizer synth;
    private VariableRateDataReader samplePlayer;
    private LineOut lineOut;

    private void test() {
        URL sampleFile;
        try {
            sampleFile = new URL("http://www.softsynth.com/samples/Clarinet.wav");
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return;
        }
        this.synth = JSyn.createSynthesizer();
        try {
            this.lineOut = new LineOut();
            this.synth.add(this.lineOut);
            SampleLoader.setJavaSoundPreferred(false);
            FloatSample sample = SampleLoader.loadFloatSample(sampleFile);
            System.out.println("Sample has: channels  = " + sample.getChannelsPerFrame());
            System.out.println("            frames    = " + sample.getNumFrames());
            System.out.println("            rate      = " + sample.getFrameRate());
            System.out.println("            loopStart = " + sample.getSustainBegin());
            System.out.println("            loopEnd   = " + sample.getSustainEnd());
            if (sample.getChannelsPerFrame() == 1) {
                this.samplePlayer = new VariableRateMonoReader();
                this.synth.add(this.samplePlayer);
                this.samplePlayer.output.connect(0, this.lineOut.input, 0);
            } else if (sample.getChannelsPerFrame() == 2) {
                this.samplePlayer = new VariableRateStereoReader();
                this.synth.add(this.samplePlayer);
                this.samplePlayer.output.connect(0, this.lineOut.input, 0);
                this.samplePlayer.output.connect(1, this.lineOut.input, 1);
            } else {
                throw new RuntimeException("Can only play mono or stereo samples.");
            }
            this.synth.start();
            this.samplePlayer.rate.set(sample.getFrameRate());
            this.lineOut.start();
            if (sample.getSustainBegin() < 0) {
                System.out.println("queue the sample");
                this.samplePlayer.dataQueue.queue(sample);
            } else {
                System.out.println("queueOn the sample");
                this.samplePlayer.dataQueue.queueOn(sample);
                this.synth.sleepFor(8.0);
                System.out.println("queueOff the sample");
                this.samplePlayer.dataQueue.queueOff(sample);
            }
            do {
                this.synth.sleepFor(1.0);
            } while (this.samplePlayer.dataQueue.hasMore());
            this.synth.sleepFor(0.5);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        new DebugSamplerDistortion().test();
    }
}

