/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.FilterStateVariable;
import com.jsyn.unitgen.MultiplyAdd;
import com.jsyn.unitgen.RedNoise;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.WhiteNoise;

public class WindCircuit
extends Circuit
implements UnitSource {
    WhiteNoise myNoise = new WhiteNoise();
    FilterStateVariable myFilter;
    RedNoise myLFO;
    MultiplyAdd myScalar;
    public UnitInputPort noiseAmp;
    public UnitInputPort modRate;
    public UnitInputPort modDepth;
    public UnitInputPort cutoff;
    public UnitInputPort resonance;
    public UnitInputPort amplitude;
    public UnitOutputPort output;

    public WindCircuit() {
        this.add(this.myNoise);
        this.myFilter = new FilterStateVariable();
        this.add(this.myFilter);
        this.myLFO = new RedNoise();
        this.add(this.myLFO);
        this.myScalar = new MultiplyAdd();
        this.add(this.myScalar);
        this.noiseAmp = this.myNoise.amplitude;
        this.addPort(this.noiseAmp, "NoiseAmp");
        this.modRate = this.myLFO.frequency;
        this.addPort(this.modRate, "ModRate");
        this.modDepth = this.myScalar.inputB;
        this.addPort(this.modDepth, "ModDepth");
        this.cutoff = this.myScalar.inputC;
        this.addPort(this.cutoff, "Cutoff");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.amplitude = this.myFilter.amplitude;
        this.addPort(this.amplitude);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.myLFO.output.connect(this.myScalar.inputA);
        this.myScalar.output.connect(this.myFilter.frequency);
        this.myNoise.output.connect(this.myFilter.input);
        this.noiseAmp.setup(0.0, 0.3, 0.4);
        this.modRate.setup(0.0, 1.0, 10.0);
        this.modDepth.setup(0.0, 300.0, 1000.0);
        this.cutoff.setup(0.0, 600.0, 1000.0);
        this.resonance.setup(0.0, 0.066, 0.2);
        this.amplitude.setup(0.0, 0.9, 0.999);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

