/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.instruments;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.FilterLowPass;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceDescription;
import com.softsynth.shared.time.TimeStamp;

public class SubtractiveSynthVoice
extends Circuit
implements UnitVoice {
    private static final long serialVersionUID = -2704222221111608377L;
    private UnitOscillator osc;
    private FilterLowPass filter;
    private EnvelopeDAHDSR ampEnv;
    private EnvelopeDAHDSR filterEnv;
    private Add cutoffAdder;
    private Multiply frequencyScaler = new Multiply();
    public UnitInputPort amplitude;
    public UnitInputPort frequency;
    public UnitInputPort pitchModulation;
    public UnitInputPort cutoff;
    public UnitInputPort cutoffRange;
    public UnitInputPort Q;
    static String[] presetNames = new String[]{"FastSaw", "SlowSaw", "BrightSaw", ""};

    public SubtractiveSynthVoice() {
        this.add(this.frequencyScaler);
        this.osc = new SawtoothOscillatorBL();
        this.add(this.osc);
        this.ampEnv = new EnvelopeDAHDSR();
        this.add(this.ampEnv);
        this.filterEnv = new EnvelopeDAHDSR();
        this.add(this.filterEnv);
        this.filter = new FilterLowPass();
        this.add(this.filter);
        this.cutoffAdder = new Add();
        this.add(this.cutoffAdder);
        this.filterEnv.output.connect(this.cutoffAdder.inputA);
        this.cutoffAdder.output.connect(this.filter.frequency);
        this.frequencyScaler.output.connect(this.osc.frequency);
        this.osc.output.connect(this.filter.input);
        this.filter.output.connect(this.ampEnv.amplitude);
        this.amplitude = this.osc.amplitude;
        this.addPort(this.amplitude, "Amplitude");
        this.frequency = this.frequencyScaler.inputA;
        this.addPort(this.frequency, "Frequency");
        this.pitchModulation = this.frequencyScaler.inputB;
        this.addPort(this.pitchModulation, "PitchMod");
        this.cutoff = this.cutoffAdder.inputB;
        this.addPort(this.cutoff, "Cutoff");
        this.cutoffRange = this.filterEnv.amplitude;
        this.addPort(this.cutoffRange, "CutoffRange");
        this.Q = this.filter.Q;
        this.addPort(this.Q);
        this.ampEnv.export(this, "Amp");
        this.filterEnv.export(this, "Filter");
        this.frequency.setup(this.osc.frequency);
        this.pitchModulation.setup(0.2, 1.0, 4.0);
        this.cutoff.setup(this.filter.frequency);
        this.cutoffRange.setup(this.filter.frequency);
        this.ampEnv.setupAutoDisable(this);
        this.usePreset(0);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
        this.ampEnv.input.off(timeStamp);
        this.filterEnv.input.off(timeStamp);
    }

    @Override
    public void noteOn(double freq, double ampl, TimeStamp timeStamp) {
        this.frequency.set(freq, timeStamp);
        this.amplitude.set(ampl, timeStamp);
        this.ampEnv.input.on(timeStamp);
        this.filterEnv.input.on(timeStamp);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.ampEnv.output;
    }

    @Override
    public void usePreset(int presetIndex) {
        int n = presetIndex % presetNames.length;
        switch (n) {
            case 0: {
                this.ampEnv.attack.set(0.01);
                this.ampEnv.decay.set(0.2);
                this.ampEnv.release.set(1.0);
                this.cutoff.set(500.0);
                this.cutoffRange.set(500.0);
                this.filter.Q.set(1.0);
                break;
            }
            case 1: {
                this.ampEnv.attack.set(0.5);
                this.ampEnv.decay.set(0.3);
                this.ampEnv.release.set(0.2);
                this.cutoff.set(500.0);
                this.cutoffRange.set(500.0);
                this.filter.Q.set(3.0);
                break;
            }
            default: {
                this.ampEnv.attack.set(0.1);
                this.ampEnv.decay.set(0.3);
                this.ampEnv.release.set(0.5);
                this.cutoff.set(2000.0);
                this.cutoffRange.set(500.0);
                this.filter.Q.set(2.0);
            }
        }
    }

    public static VoiceDescription getVoiceDescription() {
        return new MyVoiceDescription();
    }

    static class MyVoiceDescription
    extends VoiceDescription {
        String[] tags = new String[]{"electronic", "filter", "clean"};

        public MyVoiceDescription() {
            super("SubtractiveSynth", presetNames);
        }

        @Override
        public UnitVoice createUnitVoice() {
            return new SubtractiveSynthVoice();
        }

        @Override
        public String[] getTags(int presetIndex) {
            return this.tags;
        }

        @Override
        public String getVoiceClassName() {
            return SubtractiveSynthVoice.class.getName();
        }
    }
}

