/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

public class MessageParser {
    public void parse(byte[] message) {
        byte status = message[0];
        int command = status & 0xF0;
        int channel = status & 0xF;
        switch (command) {
            case 144: {
                byte velocity = message[2];
                if (velocity == 0) {
                    this.noteOff(channel, message[1], velocity);
                    break;
                }
                this.noteOn(channel, message[1], velocity);
                break;
            }
            case 128: {
                this.noteOff(channel, message[1], message[2]);
                break;
            }
            case 176: {
                this.controlChange(channel, message[1], message[2]);
                break;
            }
            case 224: {
                int bend = ((message[2] & 0x7F) << 7) + (message[1] & 0x7F);
                this.pitchBend(channel, bend);
            }
        }
    }

    public void pitchBend(int channel, int bend) {
    }

    public void controlChange(int channel, int index, int value) {
    }

    public void noteOn(int channel, int pitch, int velocity) {
    }

    public void noteOff(int channel, int pitch, int velocity) {
    }
}

