/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import junit.framework.TestCase;

public class TestRangeModels
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void checkDoubleRange(double dmin, double dmax, double dval) {
        int resolution = 1000;
        DoubleBoundedRangeModel model = new DoubleBoundedRangeModel("test", resolution, dmin, dmax, dval);
        TestRangeModels.assertEquals("setup min", dmin, model.getDoubleMinimum(), 1.0E-4);
        TestRangeModels.assertEquals("setup max", dmax, model.getDoubleMaximum(), 1.0E-4);
        TestRangeModels.assertEquals("setup value", dval, model.getDoubleValue(), 1.0E-4);
        model.setDoubleValue(dmin);
        TestRangeModels.assertEquals("min double value", dmin, model.getDoubleValue(), 1.0E-4);
        TestRangeModels.assertEquals("min value", 0, model.getValue());
        double dmid = (dmax + dmin) / 2.0;
        model.setDoubleValue(dmid);
        TestRangeModels.assertEquals("middle double value", dmid, model.getDoubleValue(), 1.0E-4);
        TestRangeModels.assertEquals("middle value", resolution / 2, model.getValue());
        model.setDoubleValue(dmax);
        TestRangeModels.assertEquals("max double value", dmax, model.getDoubleValue(), 1.0E-4);
        TestRangeModels.assertEquals("max value", resolution, model.getValue());
    }

    public void testDoubleRange() {
        this.checkDoubleRange(10.0, 20.0, 12.0);
        this.checkDoubleRange(-1.0, 1.0, 0.5);
    }
}

