/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;

public class TUT_HearEnvSustain
extends Applet {
    SineOscillator sineOsc;
    SynthEnvelope envData;
    EnvelopePlayer envPlayer;
    LineOut lineOut;
    Button attackButton;
    Button releaseButton;

    public static void main(String[] args) {
        TUT_HearEnvSustain applet = new TUT_HearEnvSustain();
        AppletFrame frame = new AppletFrame("Hear Envelope Sustain", applet);
        frame.resize(300, 100);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.sineOsc = new SineOscillator();
            this.envPlayer = new EnvelopePlayer();
            this.lineOut = new LineOut();
            this.sineOsc.output.connect(0, this.lineOut.input, 0);
            this.sineOsc.output.connect(0, this.lineOut.input, 1);
            this.envPlayer.output.connect(this.sineOsc.amplitude);
            double[] data = new double[]{0.1, 1.0, 0.3, 0.0};
            this.envData = new SynthEnvelope(data);
            this.attackButton = new Button("Attack");
            this.add(this.attackButton);
            this.releaseButton = new Button("Release");
            this.add(this.releaseButton);
            this.lineOut.start();
            this.sineOsc.start();
            this.envPlayer.start();
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.attackButton) {
            this.envPlayer.envelopePort.clear();
            this.envPlayer.envelopePort.queue(this.envData, 0, 1);
            return true;
        }
        if (evt.target == this.releaseButton) {
            this.envPlayer.envelopePort.queue(this.envData, 1, 1);
            return true;
        }
        return false;
    }
}

