/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.MixerMono;
import com.jsyn.unitgen.Unzipper;

public class MixerMonoRamped
extends MixerMono {
    private Unzipper[] unzippers;
    private Unzipper amplitudeUnzipper;

    public MixerMonoRamped(int numInputs) {
        super(numInputs);
        this.unzippers = new Unzipper[numInputs];
        int i = 0;
        while (i < numInputs) {
            this.unzippers[i] = new Unzipper();
            ++i;
        }
        this.amplitudeUnzipper = new Unzipper();
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues(0);
        double[] outputs = this.output.getValues(0);
        int i = start;
        while (i < limit) {
            double sum = 0.0;
            int n = 0;
            while (n < this.input.getNumParts()) {
                double[] inputs = this.input.getValues(n);
                double[] gains = this.gain.getValues(n);
                double smoothGain = this.unzippers[n].smooth(gains[i]);
                sum += inputs[i] * smoothGain;
                ++n;
            }
            outputs[i] = sum * this.amplitudeUnzipper.smooth(amplitudes[i]);
            ++i;
        }
    }
}

