/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class PowerOfTwo
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitOutputPort output;
    private static double[] table = new double[1026];
    private static final int NUM_VALUES = 1024;
    private double lastInput = 0.0;
    private double lastOutput = 1.0;

    static {
        int i = 0;
        while (i < table.length) {
            double value;
            PowerOfTwo.table[i] = value = Math.pow(2.0, (double)i / 1024.0);
            ++i;
        }
    }

    public PowerOfTwo() {
        this.addPort(this.input);
        this.input.setup(-8.0, 0.0, 8.0);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        int i = start;
        while (i < limit) {
            double in = inputs[i];
            if (in == this.lastInput) {
                outputs[i] = this.lastOutput;
            } else {
                int octave = (int)Math.floor(in);
                double normal = in - (double)octave;
                double findex = normal * 1024.0;
                int index = (int)findex;
                double fraction = findex - (double)index;
                double value = table[index] + fraction * (table[index + 1] - table[index]);
                while (octave > 0) {
                    --octave;
                    value *= 2.0;
                }
                while (octave < 0) {
                    ++octave;
                    value *= 0.5;
                }
                outputs[i] = value;
                this.lastInput = in;
                this.lastOutput = value;
            }
            ++i;
        }
    }
}

