/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.FloatSample;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.Grain;
import com.jsyn.unitgen.GrainFarm;
import com.jsyn.unitgen.RaisedCosineEnvelope;
import com.jsyn.unitgen.SampleGrainSource;

public class SampleGrainFarm
extends GrainFarm {
    private FloatSample sample;
    public UnitInputPort position = new UnitInputPort("Position", 0.0);
    public UnitInputPort positionRange;

    public SampleGrainFarm() {
        this.addPort(this.position);
        this.positionRange = new UnitInputPort("PositionRange", 0.0);
        this.addPort(this.positionRange);
    }

    @Override
    public void allocate(int numGrains) {
        Grain[] grainArray = new Grain[numGrains];
        int i = 0;
        while (i < numGrains) {
            Grain grain;
            grainArray[i] = grain = new Grain(new SampleGrainSource(), new RaisedCosineEnvelope());
            ++i;
        }
        this.setGrainArray(grainArray);
    }

    @Override
    public void setupGrain(Grain grain, int i) {
        SampleGrainSource sampleGrainSource = (SampleGrainSource)grain.getSource();
        sampleGrainSource.setSample(this.sample);
        sampleGrainSource.setPosition(this.position.getValues()[i]);
        sampleGrainSource.setPositionRange(this.positionRange.getValues()[i]);
        super.setupGrain(grain, i);
    }

    public void setSample(FloatSample sample) {
        this.sample = sample;
    }
}

