/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.InterpolatingDelay;
import com.jsyn.unitgen.NonRealTimeTestCase;
import com.jsyn.unitgen.SawtoothOscillator;
import com.jsyn.util.AudioStreamReader;

public class TestDelay
extends NonRealTimeTestCase {
    public void testFloor() {
        double x = -7.3;
        int n = (int)Math.floor(x);
        TestDelay.assertEquals("int", -8, n);
    }

    public void checkInterpolatingDelay(int maxFrames, double delayFrames) throws InterruptedException {
        this.synthesisEngine.start();
        System.out.printf("test delayFrames = %7.5f\n", delayFrames);
        InterpolatingDelay delay = new InterpolatingDelay();
        this.synthesisEngine.add(delay);
        delay.allocate(maxFrames);
        delay.delay.set(delayFrames / 44100.0);
        SawtoothOscillator osc = new SawtoothOscillator();
        this.synthesisEngine.add(osc);
        osc.frequency.set((double)this.synthesisEngine.getFrameRate() / 4.0);
        osc.amplitude.set(1.0);
        osc.output.connect(delay.input);
        int samplesPerFrame = 1;
        AudioStreamReader reader = new AudioStreamReader(this.synthesisEngine, samplesPerFrame);
        delay.output.connect(reader.getInput());
        delay.start();
        int i = 0;
        while (i < 3 * maxFrames) {
            if (reader.available() == 0) {
                this.synthesisEngine.sleepFor(0.01);
            }
            double actual = reader.read();
            double expected = (double)(1 + i) - delayFrames;
            if (expected < 0.0) {
                expected = 0.0;
            }
            ++i;
        }
    }

    public void testSmall() throws InterruptedException {
        this.checkInterpolatingDelay(40, 7.0);
    }

    public void testEven() throws InterruptedException {
        this.checkInterpolatingDelay(44100, 13671.0);
    }

    public void testInterpolatingDelay() throws InterruptedException {
        this.checkInterpolatingDelay(44100, 13671.4);
    }
}

