/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Compare;
import com.jsyn.unitgen.Divide;
import com.jsyn.unitgen.Maximum;
import com.jsyn.unitgen.Minimum;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.MultiplyAdd;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.Subtract;
import com.jsyn.unitgen.UnitBinaryOperator;
import junit.framework.TestCase;

public class TestMath
extends TestCase {
    SynthesisEngine synthesisEngine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAdd() {
        Add add = new Add();
        add.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        add.inputA.setValueInternal(x);
        add.inputB.setValueInternal(y);
        add.generate();
        TestMath.assertEquals("Add", x + y, add.output.getValue(), 0.001);
    }

    public void testPartialAdd() {
        Add add = new Add();
        add.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        add.inputA.setValueInternal(x);
        add.inputB.setValueInternal(y);
        add.generate(2, 5);
        TestMath.assertEquals("Add partial", 0.0, add.output.getValues()[0], 0.001);
        TestMath.assertEquals("Add partial", 0.0, add.output.getValues()[1], 0.001);
        TestMath.assertEquals("Add partial", x + y, add.output.getValues()[2], 0.001);
        TestMath.assertEquals("Add partial", x + y, add.output.getValues()[3], 0.001);
        TestMath.assertEquals("Add partial", x + y, add.output.getValues()[4], 0.001);
        TestMath.assertEquals("Add partial", 0.0, add.output.getValues()[5], 0.001);
        TestMath.assertEquals("Add partial", 0.0, add.output.getValues()[6], 0.001);
        TestMath.assertEquals("Add partial", 0.0, add.output.getValues()[7], 0.001);
    }

    public void testSubtract() {
        Subtract sub = new Subtract();
        sub.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        sub.inputA.setValueInternal(x);
        sub.inputB.setValueInternal(y);
        sub.generate();
        TestMath.assertEquals("Subtract", x - y, sub.output.getValue(), 0.001);
    }

    public void testPartialSubtract() {
        Subtract sub = new Subtract();
        sub.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        sub.inputA.setValueInternal(x);
        sub.inputB.setValueInternal(y);
        sub.generate(2, 5);
        TestMath.assertEquals("Subtract partial", 0.0, sub.output.getValues()[0], 0.001);
        TestMath.assertEquals("Subtract partial", 0.0, sub.output.getValues()[1], 0.001);
        TestMath.assertEquals("Subtract partial", x - y, sub.output.getValues()[2], 0.001);
        TestMath.assertEquals("Subtract partial", x - y, sub.output.getValues()[3], 0.001);
        TestMath.assertEquals("Subtract partial", x - y, sub.output.getValues()[4], 0.001);
        TestMath.assertEquals("Subtract partial", 0.0, sub.output.getValues()[5], 0.001);
        TestMath.assertEquals("Subtract partial", 0.0, sub.output.getValues()[6], 0.001);
        TestMath.assertEquals("Subtract partial", 0.0, sub.output.getValues()[7], 0.001);
    }

    public void testMultiply() {
        Multiply mult = new Multiply();
        mult.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        mult.inputA.setValueInternal(x);
        mult.inputB.setValueInternal(y);
        mult.generate();
        TestMath.assertEquals("Multiply", x * y, mult.output.getValue(), 0.001);
    }

    public void testPartialMultiply() {
        Multiply mult = new Multiply();
        mult.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        mult.inputA.setValueInternal(x);
        mult.inputB.setValueInternal(y);
        mult.generate(2, 5);
        TestMath.assertEquals("Multiply partial", 0.0, mult.output.getValues()[0], 0.001);
        TestMath.assertEquals("Multiply partial", 0.0, mult.output.getValues()[1], 0.001);
        TestMath.assertEquals("Multiply partial", x * y, mult.output.getValues()[2], 0.001);
        TestMath.assertEquals("Multiply partial", x * y, mult.output.getValues()[3], 0.001);
        TestMath.assertEquals("Multiply partial", x * y, mult.output.getValues()[4], 0.001);
        TestMath.assertEquals("Multiply partial", 0.0, mult.output.getValues()[5], 0.001);
        TestMath.assertEquals("Multiply partial", 0.0, mult.output.getValues()[6], 0.001);
        TestMath.assertEquals("Multiply partial", 0.0, mult.output.getValues()[7], 0.001);
    }

    public void testDivide() {
        Divide divide = new Divide();
        divide.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        divide.inputA.setValueInternal(x);
        divide.inputB.setValueInternal(y);
        divide.generate();
        TestMath.assertEquals("Divide", x / y, divide.output.getValue(), 0.001);
    }

    public void testPartialDivide() {
        Divide divide = new Divide();
        divide.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        divide.inputA.setValueInternal(x);
        divide.inputB.setValueInternal(y);
        divide.generate(2, 5);
        TestMath.assertEquals("Divide partial", 0.0, divide.output.getValues()[0], 0.001);
        TestMath.assertEquals("Divide partial", 0.0, divide.output.getValues()[1], 0.001);
        TestMath.assertEquals("Divide partial", x / y, divide.output.getValues()[2], 0.001);
        TestMath.assertEquals("Divide partial", x / y, divide.output.getValues()[3], 0.001);
        TestMath.assertEquals("Divide partial", x / y, divide.output.getValues()[4], 0.001);
        TestMath.assertEquals("Divide partial", 0.0, divide.output.getValues()[5], 0.001);
        TestMath.assertEquals("Divide partial", 0.0, divide.output.getValues()[6], 0.001);
        TestMath.assertEquals("Divide partial", 0.0, divide.output.getValues()[7], 0.001);
    }

    public void testMultiplyAdd() {
        MultiplyAdd multAdd = new MultiplyAdd();
        multAdd.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        double z = 2.28;
        multAdd.inputA.setValueInternal(x);
        multAdd.inputB.setValueInternal(y);
        multAdd.inputC.setValueInternal(z);
        multAdd.generate();
        TestMath.assertEquals("MultiplyAdd", x * y + z, multAdd.output.getValue(), 0.001);
    }

    public void testPartialMultiplyAdd() {
        MultiplyAdd multAdd = new MultiplyAdd();
        multAdd.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        double z = 2.28;
        multAdd.inputA.setValueInternal(x);
        multAdd.inputB.setValueInternal(y);
        multAdd.inputC.setValueInternal(z);
        multAdd.generate(2, 5);
        TestMath.assertEquals("MultiplyAdd partial", 0.0, multAdd.output.getValues()[0], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", 0.0, multAdd.output.getValues()[1], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", x * y + z, multAdd.output.getValues()[2], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", x * y + z, multAdd.output.getValues()[3], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", x * y + z, multAdd.output.getValues()[4], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", 0.0, multAdd.output.getValues()[5], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", 0.0, multAdd.output.getValues()[6], 0.001);
        TestMath.assertEquals("MultiplyAdd partial", 0.0, multAdd.output.getValues()[7], 0.001);
    }

    public void testCompare() {
        Compare compare = new Compare();
        compare.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        compare.inputA.setValueInternal(x);
        compare.inputB.setValueInternal(y);
        compare.generate();
        TestMath.assertEquals("Compare", (double)(x > y ? 1 : 0), compare.output.getValue(), 0.001);
    }

    public void testPartialCompare() {
        Compare compare = new Compare();
        compare.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        compare.inputA.setValueInternal(x);
        compare.inputB.setValueInternal(y);
        ((UnitBinaryOperator)compare).generate(2, 5);
        TestMath.assertEquals("Compare partial", 0.0, compare.output.getValues()[0], 0.001);
        TestMath.assertEquals("Compare partial", 0.0, compare.output.getValues()[1], 0.001);
        TestMath.assertEquals("Compare partial", (double)(x > y ? 1 : 0), compare.output.getValues()[2], 0.001);
        TestMath.assertEquals("Compare partial", (double)(x > y ? 1 : 0), compare.output.getValues()[3], 0.001);
        TestMath.assertEquals("Compare partial", (double)(x > y ? 1 : 0), compare.output.getValues()[4], 0.001);
        TestMath.assertEquals("Compare partial", 0.0, compare.output.getValues()[5], 0.001);
        TestMath.assertEquals("Compare partial", 0.0, compare.output.getValues()[6], 0.001);
        TestMath.assertEquals("Compare partial", 0.0, compare.output.getValues()[7], 0.001);
    }

    public void testMaximum() {
        Maximum max = new Maximum();
        max.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        max.inputA.setValueInternal(x);
        max.inputB.setValueInternal(y);
        max.generate();
        TestMath.assertEquals("Maximum", x > y ? x : y, max.output.getValue(), 0.001);
    }

    public void testPartialMaximum() {
        Maximum max = new Maximum();
        max.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        max.inputA.setValueInternal(x);
        max.inputB.setValueInternal(y);
        max.generate(2, 5);
        TestMath.assertEquals("Maximum partial", 0.0, max.output.getValues()[0], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, max.output.getValues()[1], 0.001);
        TestMath.assertEquals("Maximum partial", x > y ? x : y, max.output.getValues()[2], 0.001);
        TestMath.assertEquals("Maximum partial", x > y ? x : y, max.output.getValues()[3], 0.001);
        TestMath.assertEquals("Maximum partial", x > y ? x : y, max.output.getValues()[4], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, max.output.getValues()[5], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, max.output.getValues()[6], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, max.output.getValues()[7], 0.001);
    }

    public void testMinimum() {
        Minimum min = new Minimum();
        min.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        min.inputA.setValueInternal(x);
        min.inputB.setValueInternal(y);
        min.generate();
        TestMath.assertEquals("Minimum", x < y ? x : y, min.output.getValue(), 0.001);
    }

    public void testPartialMinimum() {
        Minimum min = new Minimum();
        min.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        min.inputA.setValueInternal(x);
        min.inputB.setValueInternal(y);
        min.generate(2, 5);
        TestMath.assertEquals("Maximum partial", 0.0, min.output.getValues()[0], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, min.output.getValues()[1], 0.001);
        TestMath.assertEquals("Maximum partial", x < y ? x : y, min.output.getValues()[2], 0.001);
        TestMath.assertEquals("Maximum partial", x < y ? x : y, min.output.getValues()[3], 0.001);
        TestMath.assertEquals("Maximum partial", x < y ? x : y, min.output.getValues()[4], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, min.output.getValues()[5], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, min.output.getValues()[6], 0.001);
        TestMath.assertEquals("Maximum partial", 0.0, min.output.getValues()[7], 0.001);
    }

    public void testPowerOfTwo() {
        double[] values;
        PowerOfTwo powerOfTwo = new PowerOfTwo();
        powerOfTwo.setSynthesisEngine(this.synthesisEngine);
        double smallValue = -1.5308084989341915E-17;
        double[] dArray = values = new double[]{0.0, 1.3, 4.5, -0.5, -1.0, -2.8, -1.5308084989341915E-17, 1.5308084989341915E-17, 1.0, 1.0};
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double in = dArray[n2];
            powerOfTwo.input.setValueInternal(in);
            powerOfTwo.generate();
            TestMath.assertEquals("PowerOfTwo", Math.pow(2.0, in), powerOfTwo.output.getValue(), 0.001);
            ++n2;
        }
    }
}

