/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose;

import com.jsyn.util.RecursiveSequenceGenerator;
import com.softsynth.compose.BasicContext;
import com.softsynth.compose.ChordComposer;
import com.softsynth.compose.ChordProgression;
import com.softsynth.compose.Composer;
import com.softsynth.compose.Scale;
import com.softsynth.compose.swing.ComposerSynth;
import com.softsynth.score.Column;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.ScoreRest;
import com.softsynth.score.Sequence;
import java.util.Random;

public class BasicComposer
implements Composer {
    private double density = 0.5;
    private Random melodyRandom = new Random();
    private ScoreInstrument leadInstrument;
    private ScoreInstrument drumInstrument;
    private long previousMelodySeed;
    private double entropy = 0.5;
    private BasicContext context = new BasicContext();
    private ChordComposer chordComposer;
    private RecursiveSequenceGenerator recursiveGenerator;
    private Sequence previousMelody;
    private double noteDuration = 0.5;

    public BasicComposer(ScoreInstrument leadInstrument, ScoreInstrument rhythmInstrument, ScoreInstrument drumInstrument) {
        this.leadInstrument = leadInstrument;
        this.chordComposer = new ChordComposer(this.context, rhythmInstrument);
        this.drumInstrument = drumInstrument;
        this.previousMelodySeed = this.melodyRandom.nextLong();
        this.recursiveGenerator = new RecursiveSequenceGenerator(6, 3, 64);
        this.recursiveGenerator.setRandom(this.melodyRandom);
    }

    public BasicComposer(ComposerSynth composerSynth) {
        this(composerSynth.getLeadInstrument(), composerSynth.getRhythmInstrument(), composerSynth.getDrumInstrument());
    }

    @Override
    public ScoreElement nextElement() {
        Sequence melody;
        System.out.println("Add another measure.");
        if (Math.random() > this.entropy) {
            this.melodyRandom.setSeed(this.previousMelodySeed);
        } else {
            this.previousMelodySeed = this.melodyRandom.nextLong();
        }
        Column column = new Column();
        Sequence drumSequence = this.generateDrums();
        column.add(drumSequence);
        ScoreElement rhythm = this.chordComposer.nextElement();
        column.add(rhythm);
        if (Math.random() > this.entropy && this.previousMelody != null) {
            System.out.println("DEVELOP melody");
            melody = this.developMelody(this.previousMelody);
        } else {
            System.out.println("GENERATE melody");
            melody = this.generateMelodyFromChord();
        }
        column.add(melody);
        this.previousMelody = melody;
        return column;
    }

    private Sequence generateDrums() {
        double measureDuration;
        Sequence drumSequence = new Sequence();
        drumSequence.setInstrument(this.drumInstrument);
        double timeLeft = measureDuration = this.context.getBeatsPerMeasure();
        while (timeLeft > 1.1) {
            double duration = 1.0;
            double pitch = 60.0;
            ScoreNote note = new ScoreNote(duration, pitch);
            if (timeLeft >= measureDuration) {
                note.setAmplitude(note.getAmplitude() * 4.0);
            }
            drumSequence.add(note);
            timeLeft -= duration;
        }
        return drumSequence;
    }

    private Sequence developMelody(Sequence previous) {
        Sequence melody = new Sequence();
        melody.setInstrument(this.leadInstrument);
        for (ScoreElement element : previous.getElements()) {
            System.out.println("DEVELOP: adding " + element);
            try {
                ScoreElement scoreElement = (ScoreElement)element.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            melody.add(element);
        }
        return melody;
    }

    private Sequence generateMelodyFromChord() {
        Sequence melody = new Sequence();
        melody.setInstrument(this.leadInstrument);
        double beat = 0.0;
        while (beat < 4.0) {
            int index;
            ScoreRest element = null;
            if (this.melodyRandom.nextDouble() < 0.5) {
                if (this.noteDuration > 0.3 && this.melodyRandom.nextDouble() < 0.3) {
                    this.noteDuration *= 0.5;
                } else if (this.noteDuration < 0.9 && this.melodyRandom.nextDouble() < 0.2) {
                    this.noteDuration *= 2.0;
                }
            }
            if (this.noteDuration > 4.0 - beat) {
                this.noteDuration = 4.0 - beat;
            }
            if ((index = this.recursiveGenerator.next((int)beat)) < 0) {
                element = new ScoreRest(this.noteDuration);
            } else {
                double pitch = this.context.chordScale.get(index);
                element = new ScoreNote(this.noteDuration, pitch);
            }
            System.out.println("GENERATE: adding " + element);
            melody.add(element);
            beat += this.noteDuration;
        }
        return melody;
    }

    private Sequence generateArpeggioFromChord() {
        Sequence melody = new Sequence();
        melody.setInstrument(this.leadInstrument);
        double beat = 0.0;
        int index = 0;
        this.noteDuration = 0.5;
        while (beat < 4.0) {
            double pitch = this.context.chordScale.get(index);
            ScoreNote note = new ScoreNote(this.noteDuration, pitch);
            System.out.println("ARPEGGIO: adding " + note);
            melody.add(note);
            beat += this.noteDuration;
            ++index;
        }
        return melody;
    }

    @Override
    public void setDensity(double density) {
        this.density = density;
        this.recursiveGenerator.setDensity(density);
    }

    @Override
    public void setScale(Scale scale) {
        this.context.scale = scale;
    }

    @Override
    public void setChordProgression(ChordProgression chordProgression) {
        this.chordComposer.setChordProgression(chordProgression);
    }
}

