/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

public class EqualTemperedTuning {
    static final double BASE_MIDI_C = 8.1758224;
    int notesPerOctave;
    double fundamental;
    double inverseOctave;

    public EqualTemperedTuning() {
        this(110.0, 12);
    }

    public EqualTemperedTuning(double fundamental) {
        this(fundamental, 12);
    }

    public EqualTemperedTuning(double fundamental, int notesPerOctave) {
        this.setFundamental(fundamental);
        this.setNotesPerOctave(notesPerOctave);
    }

    public void setNotesPerOctave(int notesPerOctave) {
        this.notesPerOctave = notesPerOctave;
        this.inverseOctave = 1.0 / (double)notesPerOctave;
    }

    public int getNotesPerOctave() {
        return this.notesPerOctave;
    }

    public void setFundamental(double fundamental) {
        this.fundamental = fundamental;
    }

    public double getFundamental() {
        return this.fundamental;
    }

    public double getPitch(double frequency) {
        return (double)this.notesPerOctave * Math.log(frequency / this.fundamental) / Math.log(2.0);
    }

    public double getFrequency(double pitch) {
        return this.fundamental * Math.pow(2.0, pitch * this.inverseOctave);
    }

    public double getFrequency(int pitch, int cents) {
        return this.getFrequency((double)pitch + (double)cents / 100.0);
    }

    public double getFrequency(int pitch) {
        return this.getFrequency((double)pitch);
    }

    public static double getMIDIPitch(double frequency) {
        return 12.0 * Math.log(frequency / 8.1758224) / Math.log(2.0);
    }

    public static double getMIDIFrequency(double pitch) {
        return 8.1758224 * Math.pow(2.0, pitch * 0.08333333333333333);
    }

    public static double getMIDIFrequency(int pitch, int cents) {
        return EqualTemperedTuning.getMIDIFrequency((double)pitch + (double)cents / 100.0);
    }

    public static void main(String[] args) {
        System.out.println("440 Hz = " + EqualTemperedTuning.getMIDIPitch(440.0) + " semitones");
        System.out.println("600 Hz = " + EqualTemperedTuning.getMIDIPitch(600.0) + " semitones");
        System.out.println("Middle C (60) = " + EqualTemperedTuning.getMIDIFrequency(60.0) + " Hz");
    }
}

