/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.ParseRIFF;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSampleWAV
extends SynthSample
implements ChunkHandler {
    static final short WAVE_FORMAT_PCM = 1;
    static final int WAVE_ID = 1463899717;
    static final int FMT_ID = 1718449184;
    static final int DATA_ID = 1684108385;
    static final int CUE_ID = 1668637984;
    private int bitsPerSample;
    private int bytesPerBlock;

    public SynthSampleWAV(SynthContext synthContext, InputStream stream) throws SynthException, IOException {
        super(synthContext);
        this.load(stream);
    }

    public SynthSampleWAV(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthSampleWAV(InputStream stream) throws SynthException, IOException {
        this.load(stream);
    }

    public SynthSampleWAV() {
    }

    @Override
    public short[] loadShorts(InputStream stream, boolean ifLoadData) throws SynthException, IOException {
        short[] shortData = null;
        this.ifLoadData = ifLoadData;
        ParseRIFF localParser = new ParseRIFF(stream);
        this.parser = localParser;
        localParser.parse(this);
        if (ifLoadData && this.numFrames > 0) {
            shortData = this.bitsPerSample == 8 ? this.convertUnsignedBytesToShorts() : this.convertLittleBytesToShorts();
        }
        this.byteData = null;
        this.parser = null;
        return shortData;
    }

    void setLoopPoints() {
        if (this.cuePoints != null && this.cuePoints.size() >= 2) {
            this.setSustainLoop(((CuePoint)this.cuePoints.elementAt(0)).getPosition(), ((CuePoint)this.cuePoints.elementAt(1)).getPosition());
        }
    }

    void parseCueChunk(ParseIFF parser, int ckSize) throws IOException {
        int numCuePoints = parser.readIntLittle();
        if (ckSize - 4 != 24 * numCuePoints) {
            throw new EOFException("Cue chunk too short!");
        }
        int i = 0;
        while (i < numCuePoints) {
            int uniqueID = parser.readIntLittle();
            int position = parser.readIntLittle();
            parser.skip(16L);
            this.insertSortedCue(new CuePoint(position, uniqueID));
            ++i;
        }
        this.setLoopPoints();
    }

    void parseFmtChunk(ParseIFF parser, int ckSize) throws IOException {
        short format = parser.readShortLittle();
        if (format != 1) {
            throw new IOException("Only WAVE_FORMAT_PCM supported, not " + format);
        }
        this.channelsPerFrame = parser.readShortLittle();
        this.setSampleRate(parser.readIntLittle());
        parser.readIntLittle();
        this.bytesPerBlock = parser.readShortLittle();
        this.bitsPerSample = parser.readShortLittle();
        if (this.bitsPerSample != 16 && this.bitsPerSample != 8) {
            throw new IOException("Only 8 or 16 bit samples supported.");
        }
        int bytesPerSample = (this.bitsPerSample + 7) / 8;
        int expectedBytesPerBlock = bytesPerSample * this.channelsPerFrame;
        if (this.bytesPerBlock != expectedBytesPerBlock) {
            throw new IOException("bytesPerBlock = " + this.bytesPerBlock + ", expected " + expectedBytesPerBlock);
        }
    }

    void parseDataChunk(ParseIFF parser, int ckSize) throws IOException {
        long numRead;
        if (Synth.verbosity > 1) {
            System.out.println("parseDataChunk()");
        }
        this.dataPosition = parser.getOffset();
        if (this.ifLoadData) {
            this.byteData = new byte[ckSize];
            numRead = parser.read(this.byteData);
        } else {
            numRead = parser.skip(ckSize);
        }
        if (numRead != (long)ckSize) {
            throw new EOFException("WAV data chunk too short! Read " + numRead + " instead of " + ckSize);
        }
        this.numFrames = ckSize / this.bytesPerBlock;
    }

    @Override
    public void handleForm(ParseIFF parser, int ckID, int ckSize, int type) throws IOException {
        if (ckID == 1380533830 && type != 1463899717) {
            throw new IOException("Bad WAV form type = " + ParseIFF.IDToString(type));
        }
    }

    @Override
    public void handleChunk(ParseIFF parser, int ckID, int ckSize) throws IOException {
        switch (ckID) {
            case 1718449184: {
                this.parseFmtChunk(parser, ckSize);
                break;
            }
            case 1684108385: {
                this.parseDataChunk(parser, ckSize);
                break;
            }
            case 1668637984: {
                this.parseCueChunk(parser, ckSize);
                break;
            }
        }
    }
}

