/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.SynthPort;
import java.util.Vector;

public class SynthSound
extends SynthObject {
    String name;
    Vector ports = new Vector();

    public SynthSound() {
        this(Synth.getSharedContext());
    }

    public SynthSound(SynthContext synthContext) {
        super(synthContext);
    }

    public void addPort(SynthPort port, String alias) {
        port.setAlias(alias);
        this.ports.addElement(port);
    }

    public void addPort(SynthPort port) {
        this.ports.addElement(port);
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public SynthPort getPortAt(int index) {
        return (SynthPort)this.ports.elementAt(index);
    }

    public SynthPort findNamedPort(String name) {
        int numPorts = this.getNumPorts();
        int i = 0;
        while (i < numPorts) {
            SynthPort port = this.getPortAt(i);
            if (port.getAlias().equals(name)) {
                return port;
            }
            ++i;
        }
        return null;
    }

    public void start(int time) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].start(" + time + ")");
        }
        if ((nativeError = this.context.startUnitAt(time, this.getPeer())) < 0) {
            throw new SynthException(nativeError, this.peerToken);
        }
    }

    public void start() throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].start()" + " at " + this.context.getTickCount());
        }
        if ((nativeError = this.context.startUnit(this.getPeer())) < 0) {
            throw new SynthException(nativeError, this.peerToken);
        }
    }

    public void stop(int time) throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].stop(" + time + ")");
        }
        if ((nativeError = this.context.stopUnitAt(time, this.getPeer())) < 0) {
            throw new SynthException(nativeError, this.peerToken);
        }
    }

    public void stop() throws SynthException {
        int nativeError;
        if (Synth.verbosity >= 1) {
            System.out.println("[" + Integer.toHexString(this.getPeer()) + "].stop()" + " at " + this.context.getTickCount());
        }
        if ((nativeError = this.context.stopUnit(this.getPeer())) < 0) {
            throw new SynthException(nativeError, this.peerToken);
        }
    }

    public void setPriority(int priority) throws SynthException {
        int nativeError = this.context.setPriority(this.getPeer(), priority);
        if (nativeError < 0) {
            throw new SynthException(nativeError, this.peerToken, priority);
        }
    }

    public int getPriority() throws SynthException {
        int result = this.context.getPriority(this.getPeer());
        if (result < 0) {
            this.nativeError = result;
            throw new SynthException(this.nativeError, this.peerToken);
        }
        return result;
    }

    public void setStage(int time, int stage) throws SynthException {
    }

    public void setStage(int stage) throws SynthException {
        this.setStage(this.context.getTickCount(), stage);
    }

    public String getName() {
        return this.name;
    }
}

