/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import junit.framework.TestCase;

public class TestAutoStop
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testAutoStopEnvelope() {
        double dur = 75.0 / Synth.getFrameRate();
        double[] data = new double[]{dur, 0.7, dur, 0.3};
        SynthEnvelope envelope = new SynthEnvelope(data);
        EnvelopePlayer envPlayer = new EnvelopePlayer();
        envPlayer.start();
        envPlayer.envelopePort.queue(envelope, 0, 1);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at first frame value", data[1], envPlayer.output.get(), 0.001);
        envPlayer.envelopePort.queue(envelope, 1, 1);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at second frame value", data[3], envPlayer.output.get(), 0.001);
        envPlayer.envelopePort.queue(envelope, 0, 1, 16);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at first frame value", data[1], envPlayer.output.get(), 0.001);
        envPlayer.envelopePort.queue(envelope, 1, 1);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be auto stopped at first frame.", data[1], envPlayer.output.get(), 0.001);
    }

    public void testAutoStopCircuit() {
        SimpleAutoCircuit circuit = new SimpleAutoCircuit();
        double dur = 75.0 / Synth.getFrameRate();
        double[] data = new double[]{dur, 0.7, dur, 0.3};
        SynthEnvelope envelope = new SynthEnvelope(data);
        circuit.a.set(3.0);
        circuit.b.set(4.0);
        circuit.envelopePort.queue(envelope, 0, 1);
        circuit.start();
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at first frame value", data[1], circuit.envOutput.get(), 0.001);
        TestAutoStop.assertEquals("adder should have run", 7.0, circuit.output.get(), 1.0E-4);
        circuit.envelopePort.queue(envelope, 0, 1, 16);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at first frame value", data[1], circuit.envOutput.get(), 0.001);
        circuit.a.set(5.0);
        circuit.b.set(7.0);
        circuit.envelopePort.queue(envelope, 1, 1);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be auto stopped at first frame.", data[1], circuit.envOutput.get(), 0.001);
        TestAutoStop.assertEquals("adder should not be running so should still have old value", 7.0, circuit.output.get(), 1.0E-4);
    }

    public void testChubbyBug() {
        System.out.println("testChubbyBug =====================================");
        int attackFrames = 75;
        double dur = (double)attackFrames / Synth.getFrameRate();
        double[] data = new double[]{dur, 0.7, 0.5, 0.3};
        SynthEnvelope envelope = new SynthEnvelope(data);
        EnvelopePlayer envPlayer = new EnvelopePlayer();
        envPlayer.start();
        envPlayer.envelopePort.queue(envelope, 0, 2, 16);
        Synth.sleepForTicks(2);
        envPlayer.envelopePort.clear();
        envPlayer.envelopePort.queue(envelope, 0, 1);
        Synth.sleepForTicks(2);
        TestAutoStop.assertEquals("Should be stuck at first frame value", data[1], envPlayer.output.get(), 0.001);
        envPlayer.envelopePort.queue(envelope);
        Synth.sleepForTicks(2);
        double val1 = envPlayer.output.get();
        Synth.sleepForTicks(2);
        double val2 = envPlayer.output.get();
        TestAutoStop.assertTrue("Envelope should be dropping, not stopped.", val2 < val1);
        envPlayer.stop();
    }

    static class SimpleAutoCircuit
    extends SynthCircuit {
        AddUnit adder;
        EnvelopePlayer envPlayer = new EnvelopePlayer();
        SynthInput a;
        SynthInput b;
        SynthOutput output;
        SynthOutput envOutput;
        SynthEnvelopeQueue envelopePort;

        public SimpleAutoCircuit() {
            this.adder = new AddUnit();
            this.add(this.adder);
            this.envPlayer = new EnvelopePlayer();
            this.add(this.envPlayer);
            this.a = this.adder.inputA;
            this.addPort(this.a, "A");
            this.b = this.adder.inputB;
            this.addPort(this.b, "B");
            this.output = this.adder.output;
            this.addPort(this.output);
            this.envOutput = this.envPlayer.output;
            this.addPort(this.envOutput);
            this.envelopePort = this.envPlayer.envelopePort;
            this.addPort(this.envelopePort);
        }
    }
}

