/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.WaveShaper;
import junit.framework.TestCase;

public class TestBird
extends TestCase {
    private static final int SAMPLE_SIZE = 128;
    private SynthContext context;

    @Override
    protected void setUp() throws Exception {
        this.context = new SynthContext();
        this.context.initialize();
        this.context.start(4);
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
    }

    public void testBirdLFOOutput() {
        short[] image = new short[]{74, 148, 223, 297, 371, 445, 520, 594, 668, 742, 817, 891, 965, 1039, 1114, 1188, 1262, 1336, 1411, 1485, 1559, 1633, 1708, 1782, 1856, 1930, 2004, 2079, 2153, 2227, 2301, 2376, 2450, 2524, 2598, 2673, 2747, 2821, 2895, 2970, 3044, 3118, 3192, 3267, 3341, 3415, 3489, 3563, 3638, 3712, 3786, 3860, 3935, 4009, 4083, 4157, 4232, 4306, 4380, 4454, 4529, 4603, 4677, 4751, 4826, 4900, 4974, 5048, 5123, 5197, 5271, 5345, 5419, 5494, 5568, 5642, 5716, 5791, 5865, 5939, 6013, 6088, 6162, 6236, 6310, 6385, 6459, 6533, 6607, 6682, 6756, 6830, 6904, 6979, 7053, 7127, 7201, 7275, 7350, 7424, 7498, 7572, 7647, 7721, 7795, 7869, 7944, 8018, 8092, 8166, 8241, 8315, 8389, 8463, 8538, 8612, 8686, 8760, 8835, 8909, 8983, 9057, 9131, 9206, 9280, 9354, 9428, 9503};
        CrazyBird bird1 = new CrazyBird(this.context);
        CrazyBird bird2 = new CrazyBird(this.context);
        this.check(bird1, bird2, "lfoOutput", image);
    }

    public void testBirdLagOutput() {
        short[] image = new short[]{26, 51, 77, 103, 128, 154, 179, 205, 230, 256, 281, 306, 331, 357, 382, 407, 432, 457, 482, 507, 532, 557, 582, 607, 631, 656, 681, 705, 730, 755, 779, 804, 828, 853, 877, 901, 926, 950, 974, 998, 1023, 1047, 1071, 1095, 1119, 1143, 1167, 1191, 1214, 1238, 1262, 1286, 1310, 1333, 1357, 1380, 1404, 1428, 1451, 1474, 1498, 1521, 1545, 1568, 1591, 1614, 1638, 1661, 1684, 1707, 1730, 1753, 1776, 1799, 1822, 1845, 1868, 1890, 1913, 1936, 1959, 1981, 2004, 2026, 2049, 2071, 2094, 2116, 2139, 2161, 2184, 2206, 2228, 2250, 2273, 2295, 2317, 2339, 2361, 2383, 2405, 2427, 2449, 2471, 2493, 2514, 2536, 2558, 2580, 2601, 2623, 2645, 2666, 2688, 2709, 2731, 2752, 2774, 2795, 2816, 2838, 2859, 2880, 2901, 2922, 2944, 2965, 2986};
        CrazyBird bird1 = new CrazyBird(this.context);
        CrazyBird bird2 = new CrazyBird(this.context);
        this.check(bird1, bird2, "lagOutput", image);
    }

    public void testBirdWaveShaperOutput() {
        short[] image = new short[]{26, 51, 77, 102, 127, 152, 176, 201, 225, 250, 274, 298, 322, 345, 369, 392, 415, 438, 461, 484, 507, 529, 551, 574, 596, 617, 639, 661, 682, 703, 724, 745, 766, 787, 807, 828, 848, 868, 888, 908, 928, 947, 966, 986, 1005, 1024, 1042, 1061, 1080, 1098, 1116, 1134, 1152, 1170, 1188, 1205, 1223, 1240, 1257, 1274, 1291, 1308, 1324, 1341, 1357, 1373, 1389, 1405, 1421, 1436, 1452, 1467, 1482, 1497, 1512, 1527, 1542, 1556, 1571, 1585, 1599, 1613, 1627, 1641, 1654, 1668, 1681, 1694, 1708, 1721, 1733, 1746, 1759, 1771, 1783, 1796, 1808, 1820, 1831, 1843, 1855, 1866, 1877, 1889, 1900, 1911, 1921, 1932, 1943, 1953, 1963, 1974, 1984, 1994, 2003, 2013, 2023, 2032, 2041, 2051, 2060, 2069, 2078, 2086, 2095, 2103, 2112, 2120};
        CrazyBird bird1 = new CrazyBird(this.context);
        CrazyBird bird2 = new CrazyBird(this.context);
        this.check(bird1, bird2, "waveShaperOutput", image);
    }

    public void testBirdSineOutput() {
        short[] sArray = new short[128];
        sArray[8] = 1;
        sArray[9] = 6;
        sArray[10] = 13;
        sArray[11] = 23;
        sArray[12] = 36;
        sArray[13] = 51;
        sArray[14] = 69;
        sArray[15] = 90;
        sArray[16] = 112;
        sArray[17] = 137;
        sArray[18] = 164;
        sArray[19] = 192;
        sArray[20] = 221;
        sArray[21] = 252;
        sArray[22] = 284;
        sArray[23] = 316;
        sArray[24] = 349;
        sArray[25] = 382;
        sArray[26] = 415;
        sArray[27] = 448;
        sArray[28] = 480;
        sArray[29] = 510;
        sArray[30] = 540;
        sArray[31] = 568;
        sArray[32] = 594;
        sArray[33] = 617;
        sArray[34] = 639;
        sArray[35] = 657;
        sArray[36] = 673;
        sArray[37] = 685;
        sArray[38] = 693;
        sArray[39] = 698;
        sArray[40] = 700;
        sArray[41] = 697;
        sArray[42] = 689;
        sArray[43] = 678;
        sArray[44] = 661;
        sArray[45] = 641;
        sArray[46] = 615;
        sArray[47] = 585;
        sArray[48] = 551;
        sArray[49] = 511;
        sArray[50] = 467;
        sArray[51] = 419;
        sArray[52] = 366;
        sArray[53] = 310;
        sArray[54] = 249;
        sArray[55] = 184;
        sArray[56] = 116;
        sArray[57] = 45;
        sArray[58] = -28;
        sArray[59] = -105;
        sArray[60] = -183;
        sArray[61] = -264;
        sArray[62] = -346;
        sArray[63] = -428;
        sArray[64] = -511;
        sArray[65] = -594;
        sArray[66] = -677;
        sArray[67] = -758;
        sArray[68] = -838;
        sArray[69] = -915;
        sArray[70] = -990;
        sArray[71] = -1062;
        sArray[72] = -1130;
        sArray[73] = -1193;
        sArray[74] = -1252;
        sArray[75] = -1306;
        sArray[76] = -1354;
        sArray[77] = -1396;
        sArray[78] = -1432;
        sArray[79] = -1460;
        sArray[80] = -1481;
        sArray[81] = -1494;
        sArray[82] = -1500;
        sArray[83] = -1497;
        sArray[84] = -1486;
        sArray[85] = -1466;
        sArray[86] = -1438;
        sArray[87] = -1401;
        sArray[88] = -1356;
        sArray[89] = -1302;
        sArray[90] = -1239;
        sArray[91] = -1168;
        sArray[92] = -1089;
        sArray[93] = -1002;
        sArray[94] = -908;
        sArray[95] = -807;
        sArray[96] = -699;
        sArray[97] = -585;
        sArray[98] = -466;
        sArray[99] = -342;
        sArray[100] = -214;
        sArray[101] = -82;
        sArray[102] = 51;
        sArray[103] = 188;
        sArray[104] = 325;
        sArray[105] = 463;
        sArray[106] = 600;
        sArray[107] = 735;
        sArray[108] = 868;
        sArray[109] = 998;
        sArray[110] = 1123;
        sArray[111] = 1244;
        sArray[112] = 1358;
        sArray[113] = 1466;
        sArray[114] = 1566;
        sArray[115] = 1657;
        sArray[116] = 1739;
        sArray[117] = 1812;
        sArray[118] = 1873;
        sArray[119] = 1924;
        sArray[120] = 1963;
        sArray[121] = 1989;
        sArray[122] = 2003;
        sArray[123] = 2004;
        sArray[124] = 1992;
        sArray[125] = 1967;
        sArray[126] = 1929;
        sArray[127] = 1877;
        short[] image = sArray;
        CrazyBird bird1 = new CrazyBird(this.context);
        CrazyBird bird2 = new CrazyBird(this.context);
        this.check(bird1, bird2, "sineOutput", image);
    }

    public void testBirdTriangleOutput() {
        short[] sArray = new short[128];
        sArray[8] = 1;
        sArray[9] = 4;
        sArray[10] = 8;
        sArray[11] = 15;
        sArray[12] = 23;
        sArray[13] = 33;
        sArray[14] = 45;
        sArray[15] = 59;
        sArray[16] = 75;
        sArray[17] = 92;
        sArray[18] = 112;
        sArray[19] = 133;
        sArray[20] = 155;
        sArray[21] = 180;
        sArray[22] = 206;
        sArray[23] = 234;
        sArray[24] = 264;
        sArray[25] = 296;
        sArray[26] = 329;
        sArray[27] = 364;
        sArray[28] = 401;
        sArray[29] = 439;
        sArray[30] = 479;
        sArray[31] = 521;
        sArray[32] = 564;
        sArray[33] = 610;
        sArray[34] = 622;
        sArray[35] = 617;
        sArray[36] = 609;
        sArray[37] = 600;
        sArray[38] = 589;
        sArray[39] = 576;
        sArray[40] = 561;
        sArray[41] = 544;
        sArray[42] = 526;
        sArray[43] = 505;
        sArray[44] = 483;
        sArray[45] = 459;
        sArray[46] = 433;
        sArray[47] = 405;
        sArray[48] = 375;
        sArray[49] = 344;
        sArray[50] = 311;
        sArray[51] = 276;
        sArray[52] = 239;
        sArray[53] = 200;
        sArray[54] = 160;
        sArray[55] = 118;
        sArray[56] = 74;
        sArray[57] = 29;
        sArray[58] = -17;
        sArray[59] = -66;
        sArray[60] = -117;
        sArray[61] = -169;
        sArray[62] = -223;
        sArray[63] = -278;
        sArray[64] = -336;
        sArray[65] = -394;
        sArray[66] = -455;
        sArray[67] = -517;
        sArray[68] = -580;
        sArray[69] = -645;
        sArray[70] = -712;
        sArray[71] = -780;
        sArray[72] = -850;
        sArray[73] = -921;
        sArray[74] = -994;
        sArray[75] = -1068;
        sArray[76] = -1144;
        sArray[77] = -1222;
        sArray[78] = -1300;
        sArray[79] = -1381;
        sArray[80] = -1462;
        sArray[81] = -1447;
        sArray[82] = -1393;
        sArray[83] = -1337;
        sArray[84] = -1279;
        sArray[85] = -1219;
        sArray[86] = -1158;
        sArray[87] = -1095;
        sArray[88] = -1030;
        sArray[89] = -964;
        sArray[90] = -897;
        sArray[91] = -827;
        sArray[92] = -757;
        sArray[93] = -684;
        sArray[94] = -610;
        sArray[95] = -535;
        sArray[96] = -458;
        sArray[97] = -380;
        sArray[98] = -300;
        sArray[99] = -219;
        sArray[100] = -136;
        sArray[101] = -52;
        sArray[102] = 33;
        sArray[103] = 120;
        sArray[104] = 208;
        sArray[105] = 298;
        sArray[106] = 389;
        sArray[107] = 481;
        sArray[108] = 575;
        sArray[109] = 670;
        sArray[110] = 767;
        sArray[111] = 864;
        sArray[112] = 963;
        sArray[113] = 1064;
        sArray[114] = 1165;
        sArray[115] = 1268;
        sArray[116] = 1372;
        sArray[117] = 1477;
        sArray[118] = 1583;
        sArray[119] = 1691;
        sArray[120] = 1799;
        sArray[121] = 1909;
        sArray[122] = 1986;
        sArray[123] = 1894;
        sArray[124] = 1800;
        sArray[125] = 1704;
        sArray[126] = 1608;
        sArray[127] = 1510;
        short[] image = sArray;
        CrazyBird bird1 = new CrazyBird(this.context);
        CrazyBird bird2 = new CrazyBird(this.context);
        this.check(bird1, bird2, "Output", image);
    }

    private void check(CrazyBird bird1, CrazyBird bird2, String portName, short[] image) {
        System.out.println("Test " + portName);
        SignalChecker checker = new SignalChecker(this.context);
        if (image == null) {
            image = new short[128];
            bird2.start();
            bird2.chirp();
            checker.record((SynthOutput)bird2.findNamedPort(portName), image);
            checker.dumpSource(image);
        }
        bird1.start();
        bird1.chirp();
        checker.compare((SynthOutput)bird1.findNamedPort(portName), image);
    }

    class CrazyBird
    extends SynthCircuit {
        SineOscillator unitSineOsc;
        TriangleOscillator unitTriOsc;
        SawtoothOscillatorBL unitLFO1;
        ExponentialLag unitLagAmp;
        MultiplyAddUnit unitFreqMix;
        WaveShaper unitWaveShaper;
        BusWriter unitBusWriter;
        SynthTable tableMod2Amp;

        public CrazyBird(SynthContext synthContext) throws SynthException {
            super(synthContext);
            this.unitSineOsc = new SineOscillator(synthContext);
            this.add(this.unitSineOsc);
            this.unitTriOsc = new TriangleOscillator(synthContext);
            this.add(this.unitTriOsc);
            this.unitLFO1 = new SawtoothOscillatorBL(synthContext);
            this.add(this.unitLFO1);
            this.unitLagAmp = new ExponentialLag(synthContext);
            this.add(this.unitLagAmp);
            this.unitFreqMix = new MultiplyAddUnit(synthContext);
            this.add(this.unitFreqMix);
            this.unitWaveShaper = new WaveShaper(synthContext);
            this.add(this.unitWaveShaper);
            this.unitBusWriter = new BusWriter(synthContext);
            this.add(this.unitBusWriter);
            this.addPort(this.unitTriOsc.output);
            this.addPort(this.unitSineOsc.output, "sineOutput");
            this.addPort(this.unitLFO1.output, "lfoOutput");
            this.addPort(this.unitLagAmp.output, "lagOutput");
            this.addPort(this.unitWaveShaper.output, "waveShaperOutput");
            this.addPort(this.unitFreqMix.output, "freqMixOutput");
            double[] data = new double[]{0.0, 1.0, 0.0};
            this.tableMod2Amp = new SynthTable(synthContext, data);
            this.unitWaveShaper.tablePort.setTable(this.tableMod2Amp);
            this.unitLFO1.output.connect(this.unitWaveShaper.input);
            this.unitLagAmp.halfLife.set(0.01);
            this.unitLagAmp.output.connect(this.unitWaveShaper.amplitude);
            this.unitWaveShaper.amplitude.set(0.1);
            this.unitWaveShaper.output.connect(this.unitTriOsc.amplitude);
            this.unitWaveShaper.output.connect(this.unitSineOsc.amplitude);
            this.unitLFO1.output.connect(this.unitFreqMix.inputA);
            this.unitFreqMix.output.connect(this.unitTriOsc.frequency);
            this.unitFreqMix.output.connect(this.unitSineOsc.frequency);
            this.compile();
        }

        public void chirp() throws SynthException {
            int ticks = this.getSynthContext().getTickCount();
            int i = 0;
            while (i < 6) {
                this.unitLagAmp.input.set(ticks, 0.5);
                this.unitLFO1.frequency.set(ticks, 50.0 * (double)(1 + i));
                this.unitFreqMix.inputB.set(ticks, 600.0 * (double)(1 + i) + 10.0);
                this.unitFreqMix.inputC.set(ticks, 400.0 + (double)(i * 100));
                this.unitLagAmp.input.set(ticks += 5, 0.0);
                ticks += 5;
                ++i;
            }
        }
    }
}

