/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Filter_BandPass;
import com.softsynth.jsyn.Filter_BandStop;
import com.softsynth.jsyn.Filter_HighPass;
import com.softsynth.jsyn.Filter_LowPass;
import com.softsynth.jsyn.Filter_PeakingEQ;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.TunableFilter;
import junit.framework.TestCase;

public class TestTunableFilters
extends TestCase {
    private static final int SAMPLE_SIZE = 128;
    private static final double FILTER_FREQ = 1000.0;
    private static final double FILTER_Q = 10.0;
    private static final double OSC_FREQ = 900.0;
    static short[] imageLowPass;
    static short[] imageHighPass;
    static short[] imageBandPass;
    static short[] imageBandStop;
    static short[] imagePeakingEQ;
    SynthContext context;

    static {
        short[] sArray = new short[128];
        sArray[24] = 82;
        sArray[25] = 327;
        sArray[26] = 644;
        sArray[27] = 943;
        sArray[28] = 1219;
        sArray[29] = 1467;
        sArray[30] = 1682;
        sArray[31] = 1860;
        sArray[32] = 1998;
        sArray[33] = 2094;
        sArray[34] = 2146;
        sArray[35] = 2154;
        sArray[36] = 2119;
        sArray[37] = 2042;
        sArray[38] = 1925;
        sArray[39] = 1771;
        sArray[40] = 1583;
        sArray[41] = 1366;
        sArray[42] = 1125;
        sArray[43] = 864;
        sArray[44] = 590;
        sArray[45] = 307;
        sArray[46] = 23;
        sArray[47] = -257;
        sArray[48] = -529;
        sArray[49] = -786;
        sArray[50] = -1024;
        sArray[51] = -1238;
        sArray[52] = -1424;
        sArray[53] = -1578;
        sArray[54] = -1699;
        sArray[55] = -1784;
        sArray[56] = -1831;
        sArray[57] = -1842;
        sArray[58] = -1814;
        sArray[59] = -1751;
        sArray[60] = -1654;
        sArray[61] = -1524;
        sArray[62] = -1366;
        sArray[63] = -1182;
        sArray[64] = -977;
        sArray[65] = -755;
        sArray[66] = -522;
        sArray[67] = -281;
        sArray[68] = -37;
        sArray[69] = 202;
        sArray[70] = 435;
        sArray[71] = 657;
        sArray[72] = 861;
        sArray[73] = 1128;
        sArray[74] = 1534;
        sArray[75] = 1985;
        sArray[76] = 2390;
        sArray[77] = 2741;
        sArray[78] = 3032;
        sArray[79] = 3258;
        sArray[80] = 3415;
        sArray[81] = 3501;
        sArray[82] = 3516;
        sArray[83] = 3459;
        sArray[84] = 3334;
        sArray[85] = 3143;
        sArray[86] = 2892;
        sArray[87] = 2587;
        sArray[88] = 2233;
        sArray[89] = 1840;
        sArray[90] = 1415;
        sArray[91] = 967;
        sArray[92] = 507;
        sArray[93] = 43;
        sArray[94] = -415;
        sArray[95] = -859;
        sArray[96] = -1279;
        sArray[97] = -1667;
        sArray[98] = -2017;
        sArray[99] = -2321;
        sArray[100] = -2574;
        sArray[101] = -2771;
        sArray[102] = -2910;
        sArray[103] = -2989;
        sArray[104] = -3006;
        sArray[105] = -2962;
        sArray[106] = -2860;
        sArray[107] = -2701;
        sArray[108] = -2490;
        sArray[109] = -2232;
        sArray[110] = -1933;
        sArray[111] = -1599;
        sArray[112] = -1237;
        sArray[113] = -856;
        sArray[114] = -463;
        sArray[115] = -66;
        sArray[116] = 326;
        sArray[117] = 706;
        sArray[118] = 1067;
        sArray[119] = 1402;
        sArray[120] = 1703;
        sArray[121] = 1966;
        sArray[122] = 2268;
        sArray[123] = 2686;
        sArray[124] = 3125;
        sArray[125] = 3496;
        sArray[126] = 3791;
        sArray[127] = 4005;
        imageLowPass = sArray;
        short[] sArray2 = new short[128];
        sArray2[24] = 16186;
        sArray2[25] = -553;
        sArray2[26] = -860;
        sArray2[27] = -1145;
        sArray2[28] = -1403;
        sArray2[29] = -1629;
        sArray2[30] = -1819;
        sArray2[31] = -1970;
        sArray2[32] = -2079;
        sArray2[33] = -2145;
        sArray2[34] = -2166;
        sArray2[35] = -2144;
        sArray2[36] = -2079;
        sArray2[37] = -1973;
        sArray2[38] = -1828;
        sArray2[39] = -1649;
        sArray2[40] = -1439;
        sArray2[41] = -1204;
        sArray2[42] = -947;
        sArray2[43] = -675;
        sArray2[44] = -393;
        sArray2[45] = -107;
        sArray2[46] = 176;
        sArray2[47] = 453;
        sArray2[48] = 716;
        sArray2[49] = 961;
        sArray2[50] = 1184;
        sArray2[51] = 1380;
        sArray2[52] = 1545;
        sArray2[53] = 1676;
        sArray2[54] = 1772;
        sArray2[55] = 1831;
        sArray2[56] = 1853;
        sArray2[57] = 1837;
        sArray2[58] = 1784;
        sArray2[59] = 1695;
        sArray2[60] = 1574;
        sArray2[61] = 1424;
        sArray2[62] = 1246;
        sArray2[63] = 1046;
        sArray2[64] = 828;
        sArray2[65] = 596;
        sArray2[66] = 355;
        sArray2[67] = 111;
        sArray2[68] = -131;
        sArray2[69] = -368;
        sArray2[70] = -594;
        sArray2[71] = -805;
        sArray2[72] = -997;
        sArray2[73] = 15019;
        sArray2[74] = -1864;
        sArray2[75] = -2285;
        sArray2[76] = -2655;
        sArray2[77] = -2966;
        sArray2[78] = -3213;
        sArray2[79] = -3391;
        sArray2[80] = -3499;
        sArray2[81] = -3535;
        sArray2[82] = -3500;
        sArray2[83] = -3394;
        sArray2[84] = -3222;
        sArray2[85] = -2987;
        sArray2[86] = -2695;
        sArray2[87] = -2353;
        sArray2[88] = -1969;
        sArray2[89] = -1550;
        sArray2[90] = -1107;
        sArray2[91] = -647;
        sArray2[92] = -180;
        sArray2[93] = 282;
        sArray2[94] = 734;
        sArray2[95] = 1164;
        sArray2[96] = 1565;
        sArray2[97] = 1928;
        sArray2[98] = 2248;
        sArray2[99] = 2518;
        sArray2[100] = 2733;
        sArray2[101] = 2891;
        sArray2[102] = 2988;
        sArray2[103] = 3023;
        sArray2[104] = 2997;
        sArray2[105] = 2912;
        sArray2[106] = 2768;
        sArray2[107] = 2572;
        sArray2[108] = 2326;
        sArray2[109] = 2037;
        sArray2[110] = 1711;
        sArray2[111] = 1355;
        sArray2[112] = 977;
        sArray2[113] = 584;
        sArray2[114] = 186;
        sArray2[115] = -210;
        sArray2[116] = -597;
        sArray2[117] = -966;
        sArray2[118] = -1311;
        sArray2[119] = -1625;
        sArray2[120] = -1901;
        sArray2[121] = -2135;
        sArray2[122] = 13862;
        sArray2[123] = -3016;
        sArray2[124] = -3409;
        sArray2[125] = -3729;
        sArray2[126] = -3969;
        sArray2[127] = -4126;
        imageHighPass = sArray2;
        short[] sArray3 = new short[128];
        sArray3[24] = 116;
        sArray3[25] = 227;
        sArray3[26] = 217;
        sArray3[27] = 203;
        sArray3[28] = 184;
        sArray3[29] = 163;
        sArray3[30] = 138;
        sArray3[31] = 111;
        sArray3[32] = 82;
        sArray3[33] = 52;
        sArray3[34] = 21;
        sArray3[35] = -8;
        sArray3[36] = -39;
        sArray3[37] = -68;
        sArray3[38] = -95;
        sArray3[39] = -120;
        sArray3[40] = -142;
        sArray3[41] = -160;
        sArray3[42] = -176;
        sArray3[43] = -187;
        sArray3[44] = -195;
        sArray3[45] = -199;
        sArray3[46] = -198;
        sArray3[47] = -194;
        sArray3[48] = -185;
        sArray3[49] = -173;
        sArray3[50] = -158;
        sArray3[51] = -140;
        sArray3[52] = -119;
        sArray3[53] = -96;
        sArray3[54] = -71;
        sArray3[55] = -46;
        sArray3[56] = -19;
        sArray3[57] = 6;
        sArray3[58] = 32;
        sArray3[59] = 57;
        sArray3[60] = 80;
        sArray3[61] = 101;
        sArray3[62] = 121;
        sArray3[63] = 137;
        sArray3[64] = 150;
        sArray3[65] = 160;
        sArray3[66] = 167;
        sArray3[67] = 171;
        sArray3[68] = 170;
        sArray3[69] = 167;
        sArray3[70] = 160;
        sArray3[71] = 150;
        sArray3[72] = 137;
        sArray3[73] = 237;
        sArray3[74] = 331;
        sArray3[75] = 301;
        sArray3[76] = 266;
        sArray3[77] = 226;
        sArray3[78] = 182;
        sArray3[79] = 135;
        sArray3[80] = 86;
        sArray3[81] = 35;
        sArray3[82] = -14;
        sArray3[83] = -63;
        sArray3[84] = -110;
        sArray3[85] = -155;
        sArray3[86] = -195;
        sArray3[87] = -231;
        sArray3[88] = -262;
        sArray3[89] = -287;
        sArray3[90] = -306;
        sArray3[91] = -319;
        sArray3[92] = -325;
        sArray3[93] = -324;
        sArray3[94] = -317;
        sArray3[95] = -303;
        sArray3[96] = -284;
        sArray3[97] = -259;
        sArray3[98] = -229;
        sArray3[99] = -195;
        sArray3[100] = -157;
        sArray3[101] = -117;
        sArray3[102] = -75;
        sArray3[103] = -33;
        sArray3[104] = 9;
        sArray3[105] = 52;
        sArray3[106] = 92;
        sArray3[107] = 130;
        sArray3[108] = 165;
        sArray3[109] = 196;
        sArray3[110] = 223;
        sArray3[111] = 245;
        sArray3[112] = 262;
        sArray3[113] = 273;
        sArray3[114] = 278;
        sArray3[115] = 278;
        sArray3[116] = 272;
        sArray3[117] = 261;
        sArray3[118] = 245;
        sArray3[119] = 224;
        sArray3[120] = 199;
        sArray3[121] = 170;
        sArray3[122] = 254;
        sArray3[123] = 331;
        sArray3[124] = 285;
        sArray3[125] = 234;
        sArray3[126] = 179;
        sArray3[127] = 121;
        imageBandPass = sArray3;
        short[] sArray4 = new short[128];
        sArray4[24] = 16268;
        sArray4[25] = -226;
        sArray4[26] = -216;
        sArray4[27] = -202;
        sArray4[28] = -183;
        sArray4[29] = -162;
        sArray4[30] = -137;
        sArray4[31] = -110;
        sArray4[32] = -81;
        sArray4[33] = -51;
        sArray4[34] = -20;
        sArray4[35] = 9;
        sArray4[36] = 40;
        sArray4[37] = 69;
        sArray4[38] = 96;
        sArray4[39] = 121;
        sArray4[40] = 143;
        sArray4[41] = 161;
        sArray4[42] = 177;
        sArray4[43] = 188;
        sArray4[44] = 196;
        sArray4[45] = 200;
        sArray4[46] = 199;
        sArray4[47] = 195;
        sArray4[48] = 186;
        sArray4[49] = 174;
        sArray4[50] = 159;
        sArray4[51] = 141;
        sArray4[52] = 120;
        sArray4[53] = 97;
        sArray4[54] = 72;
        sArray4[55] = 47;
        sArray4[56] = 20;
        sArray4[57] = -5;
        sArray4[58] = -31;
        sArray4[59] = -56;
        sArray4[60] = -79;
        sArray4[61] = -100;
        sArray4[62] = -120;
        sArray4[63] = -136;
        sArray4[64] = -149;
        sArray4[65] = -159;
        sArray4[66] = -166;
        sArray4[67] = -170;
        sArray4[68] = -169;
        sArray4[69] = -166;
        sArray4[70] = -159;
        sArray4[71] = -149;
        sArray4[72] = -136;
        sArray4[73] = 16147;
        sArray4[74] = -330;
        sArray4[75] = -300;
        sArray4[76] = -265;
        sArray4[77] = -225;
        sArray4[78] = -181;
        sArray4[79] = -134;
        sArray4[80] = -85;
        sArray4[81] = -34;
        sArray4[82] = 15;
        sArray4[83] = 64;
        sArray4[84] = 111;
        sArray4[85] = 156;
        sArray4[86] = 196;
        sArray4[87] = 232;
        sArray4[88] = 263;
        sArray4[89] = 288;
        sArray4[90] = 307;
        sArray4[91] = 320;
        sArray4[92] = 326;
        sArray4[93] = 325;
        sArray4[94] = 318;
        sArray4[95] = 304;
        sArray4[96] = 285;
        sArray4[97] = 260;
        sArray4[98] = 230;
        sArray4[99] = 196;
        sArray4[100] = 158;
        sArray4[101] = 118;
        sArray4[102] = 76;
        sArray4[103] = 34;
        sArray4[104] = -8;
        sArray4[105] = -51;
        sArray4[106] = -91;
        sArray4[107] = -129;
        sArray4[108] = -164;
        sArray4[109] = -195;
        sArray4[110] = -222;
        sArray4[111] = -244;
        sArray4[112] = -261;
        sArray4[113] = -272;
        sArray4[114] = -277;
        sArray4[115] = -277;
        sArray4[116] = -271;
        sArray4[117] = -260;
        sArray4[118] = -244;
        sArray4[119] = -223;
        sArray4[120] = -198;
        sArray4[121] = -169;
        sArray4[122] = 16130;
        sArray4[123] = -330;
        sArray4[124] = -284;
        sArray4[125] = -233;
        sArray4[126] = -178;
        sArray4[127] = -120;
        imageBandStop = sArray4;
        short[] sArray5 = new short[128];
        sArray5[24] = 16518;
        sArray5[25] = 264;
        sArray5[26] = 254;
        sArray5[27] = 238;
        sArray5[28] = 218;
        sArray5[29] = 194;
        sArray5[30] = 166;
        sArray5[31] = 135;
        sArray5[32] = 102;
        sArray5[33] = 67;
        sArray5[34] = 30;
        sArray5[35] = -5;
        sArray5[36] = -41;
        sArray5[37] = -77;
        sArray5[38] = -110;
        sArray5[39] = -140;
        sArray5[40] = -168;
        sArray5[41] = -192;
        sArray5[42] = -212;
        sArray5[43] = -227;
        sArray5[44] = -238;
        sArray5[45] = -244;
        sArray5[46] = -245;
        sArray5[47] = -240;
        sArray5[48] = -231;
        sArray5[49] = -218;
        sArray5[50] = -200;
        sArray5[51] = -178;
        sArray5[52] = -153;
        sArray5[53] = -124;
        sArray5[54] = -94;
        sArray5[55] = -62;
        sArray5[56] = -29;
        sArray5[57] = 4;
        sArray5[58] = 37;
        sArray5[59] = 69;
        sArray5[60] = 99;
        sArray5[61] = 128;
        sArray5[62] = 153;
        sArray5[63] = 175;
        sArray5[64] = 194;
        sArray5[65] = 208;
        sArray5[66] = 218;
        sArray5[67] = 223;
        sArray5[68] = 224;
        sArray5[69] = 221;
        sArray5[70] = 213;
        sArray5[71] = 201;
        sArray5[72] = 184;
        sArray5[73] = 16682;
        sArray5[74] = 406;
        sArray5[75] = 370;
        sArray5[76] = 327;
        sArray5[77] = 278;
        sArray5[78] = 223;
        sArray5[79] = 165;
        sArray5[80] = 104;
        sArray5[81] = 41;
        sArray5[82] = -22;
        sArray5[83] = -84;
        sArray5[84] = -144;
        sArray5[85] = -200;
        sArray5[86] = -252;
        sArray5[87] = -299;
        sArray5[88] = -339;
        sArray5[89] = -372;
        sArray5[90] = -397;
        sArray5[91] = -414;
        sArray5[92] = -422;
        sArray5[93] = -422;
        sArray5[94] = -413;
        sArray5[95] = -396;
        sArray5[96] = -371;
        sArray5[97] = -339;
        sArray5[98] = -300;
        sArray5[99] = -255;
        sArray5[100] = -206;
        sArray5[101] = -153;
        sArray5[102] = -97;
        sArray5[103] = -40;
        sArray5[104] = 17;
        sArray5[105] = 74;
        sArray5[106] = 129;
        sArray5[107] = 181;
        sArray5[108] = 229;
        sArray5[109] = 272;
        sArray5[110] = 309;
        sArray5[111] = 339;
        sArray5[112] = 363;
        sArray5[113] = 378;
        sArray5[114] = 386;
        sArray5[115] = 387;
        sArray5[116] = 379;
        sArray5[117] = 364;
        sArray5[118] = 342;
        sArray5[119] = 312;
        sArray5[120] = 277;
        sArray5[121] = 237;
        sArray5[122] = 16710;
        sArray5[123] = 407;
        sArray5[124] = 346;
        sArray5[125] = 278;
        sArray5[126] = 206;
        sArray5[127] = 130;
        imagePeakingEQ = sArray5;
    }

    @Override
    protected void setUp() throws Exception {
        this.context = new SynthContext();
        this.context.initialize();
        this.context.start(4);
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
    }

    public void testLowPass() {
        this.check(new Filter_LowPass(this.context), new Filter_LowPass(this.context), imageLowPass);
    }

    public void testHighPass() {
        this.check(new Filter_HighPass(this.context), new Filter_HighPass(this.context), imageHighPass);
    }

    public void testBandPass() {
        this.check(new Filter_BandPass(this.context), new Filter_BandPass(this.context), imageBandPass);
    }

    public void testBandStop() {
        this.check(new Filter_BandStop(this.context), new Filter_BandStop(this.context), imageBandStop);
    }

    public void testPeakingEQ() {
        this.check(new Filter_PeakingEQ(this.context), new Filter_PeakingEQ(this.context), imagePeakingEQ);
    }

    private void check(TunableFilter filter, TunableFilter filter2, short[] image) {
        ImpulseOscillator osc = new ImpulseOscillator(this.context);
        osc.frequency.set(900.0);
        osc.amplitude.set(0.5);
        osc.start();
        this.setupFilter(filter);
        osc.output.connect(filter.input);
        SignalChecker checker = new SignalChecker(this.context);
        if (image == null) {
            this.setupFilter(filter2);
            osc.output.connect(filter2.input);
            osc.phase.set(0.0);
            image = new short[128];
            filter2.start();
            checker.record(filter2.output, image);
            checker.dumpSource(image);
        }
        filter.start();
        osc.phase.set(0.0);
        checker.compare(filter.output, image);
    }

    private void setupFilter(TunableFilter filter) {
        filter.frequency.set(1000.0);
        filter.Q.set(10.0);
        if (filter instanceof Filter_PeakingEQ) {
            Filter_PeakingEQ filterEQ = (Filter_PeakingEQ)filter;
            filterEQ.gain.set(3.0);
        }
    }
}

