/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.view102.SoundTester;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;

public class Fanfare
extends Applet {
    FilteredSawtoothBL[] fsbl;
    static final int NUM_VOICES = 3;
    LineOut myOut;
    SynthMixer mixer;
    Button bang;

    public static void main(String[] args) {
        Fanfare applet = new Fanfare();
        AppletFrame frame = new AppletFrame("Simple Fanfare", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.mixer = new SynthMixer(3, 2);
            this.fsbl = new FilteredSawtoothBL[3];
            int i = 0;
            while (i < 3) {
                this.fsbl[i] = new FilteredSawtoothBL();
                this.mixer.connectInput(i, this.fsbl[i].output, 0);
                this.mixer.setGain(i, 0, (double)i * 0.2);
                this.mixer.setGain(i, 1, (double)(3 - i - 1) * 0.2);
                ++i;
            }
            this.myOut = new LineOut();
            this.mixer.connectOutput(0, this.myOut.input, 0);
            this.mixer.connectOutput(1, this.myOut.input, 1);
            this.myOut.start();
            this.mixer.start();
            this.play();
            this.add(new SoundTester(this.fsbl[0]));
            this.bang = new Button("Bang");
            this.add(this.bang);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    public void play() throws SynthException {
        int dur = (int)(Synth.getTickRate() * 0.5);
        int now = Synth.getTickCount() + dur;
        double freq = 150.0;
        double ampl = 0.3;
        this.fsbl[0].noteOnFor(now, dur / 2, freq, ampl);
        this.fsbl[1].noteOnFor(now += dur / 2, dur / 2, freq *= 1.25, ampl);
        this.fsbl[0].noteOnFor(now += dur / 2, dur / 2, freq *= 0.75, ampl);
        this.fsbl[2].noteOnFor(now, dur / 2, freq * 0.8, ampl);
        this.fsbl[1].noteOnFor(now += dur / 2, dur / 2, freq *= 1.3333333333333333, ampl);
        this.fsbl[0].noteOnFor(now += dur / 4, dur, freq *= 1.3333333333333333, ampl);
        this.fsbl[2].noteOnFor(now += dur / 4, dur, freq * 1.5, ampl);
        this.fsbl[1].noteOnFor(now, dur, freq * 1.25, ampl);
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (this.bang == evt.target) {
            try {
                this.play();
            }
            catch (SynthException e) {
                SynthAlert.showError((Component)this, e);
            }
            return true;
        }
        return false;
    }
}

