/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Filter_1o1p;
import com.softsynth.jsyn.Filter_1o1p1z;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.Filter_2o2p;
import com.softsynth.jsyn.Filter_2o2p2z;
import com.softsynth.jsyn.Filter_BandPass;
import com.softsynth.jsyn.Filter_BandStop;
import com.softsynth.jsyn.Filter_HighPass;
import com.softsynth.jsyn.Filter_HighShelf;
import com.softsynth.jsyn.Filter_LowPass;
import com.softsynth.jsyn.Filter_LowShelf;
import com.softsynth.jsyn.Filter_PeakingEQ;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PinkNoise;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthFilter;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.TunableFilter;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.LabelledFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import com.softsynth.jsyn.view11x.Tweakable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FilterFun
extends Applet
implements Tweakable {
    static final Color filterColor = Color.cyan;
    WhiteNoise whiteNoise;
    PinkNoise pinkNoise;
    RedNoise redNoise;
    ImpulseOscillator impulse;
    SawtoothOscillatorBL sawtooth;
    SineOscillator sineosc;
    SynthUnit currentSource = null;
    SynthOutput currentSourceOutput = null;
    SynthInput currentSourceAmplitude = null;
    SynthFilter currentFilter = null;
    AddUnit srcTap;
    AddUnit filterTap;
    static final double MIN_CUTOFF = 10.0;
    static final double DEF_CUTOFF = 400.0;
    static final double MAX_CUTOFF = 10000.0;
    double freqValue = 2000.0;
    double ampValue = 0.5;
    double cutoffValue = 5000.0;
    double bandwidthValue = 0.5;
    double dBGainValue = 0.0;
    double slopeValue = 1.0;
    FunFilter funBiquad;
    FunFilter funSVF;
    FunFilter fun1Z;
    FunFilter fun1P;
    FunFilter fun1P1Z;
    FunFilter fun2P;
    FunFilter funLowPass;
    FunFilter funHighPass;
    FunFilter funBandPass;
    FunFilter funBandStop;
    FunFilter funPeakingEQ;
    FunFilter funLowShelf;
    FunFilter funHighShelf;
    LineOut myOut;
    Choice sourceChoice;
    Choice filterChoice;
    LabelledFader freqFader;
    LabelledFader ampFader;
    Panel filterGUI;
    SynthScope scope;
    static final int LOW_PASS = 0;
    static final int BAND_PASS = 1;
    static final int HIGH_PASS = 2;
    static final int NOTCH = 3;
    static final int PEAKING_EQ = 4;
    static final int LOW_SHELF = 5;
    static final int HIGH_SHELF = 6;

    public static void main(String[] args) {
        FilterFun applet = new FilterFun();
        AppletFrame frame = new AppletFrame("Filter Fun", applet);
        frame.resize(700, 500);
        frame.show();
        frame.test();
    }

    void buildGUI() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = 1;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        constraint.gridx = 0;
        constraint.gridy = -1;
        constraint.weightx = 1.0;
        constraint.weighty = 0.0;
        gridbag.setConstraints(this.makeSourcePanel(), constraint);
        this.freqFader = new LabelledFader(this, 0, "Source Frequency", this.freqValue, 10.0, 10000.0);
        this.add(this.freqFader);
        this.freqFader.getFader().setTaper(1);
        gridbag.setConstraints(this.freqFader, constraint);
        this.ampFader = new LabelledFader(this, 1, "Source Amplitude", this.ampValue, 0.001, 1.0);
        this.add(this.ampFader);
        this.ampFader.getFader().setTaper(1);
        gridbag.setConstraints(this.ampFader, constraint);
        gridbag.setConstraints(this.makeFilterPanel(), constraint);
        this.filterGUI = new Panel();
        this.add(this.filterGUI);
        this.filterGUI.setLayout(new BorderLayout());
        this.filterGUI.setBackground(filterColor);
        constraint.gridheight = 4;
        constraint.weighty = 1.0;
        gridbag.setConstraints(this.filterGUI, constraint);
        this.scope = new SynthScope();
        this.add(this.scope);
        this.scope.createProbe(this.srcTap.output, "Source", Color.red);
        this.scope.createProbe(this.filterTap.output, "Filtered", Color.green);
        this.scope.finish();
        this.scope.hideControls();
        constraint.gridheight = 0;
        constraint.weighty = 2.0;
        gridbag.setConstraints(this.scope, constraint);
        this.getParent().validate();
        this.getToolkit().sync();
    }

    Panel makeSourcePanel() {
        Panel panel = new Panel();
        this.add(panel);
        panel.add(new Label("Select Source:"));
        this.sourceChoice = new Choice();
        panel.add(this.sourceChoice);
        this.sourceChoice.addItem("WhiteNoise");
        this.sourceChoice.addItem("PinkNoise");
        this.sourceChoice.addItem("RedNoise");
        this.sourceChoice.addItem("Impulse");
        this.sourceChoice.addItem("Sawtooth");
        this.sourceChoice.addItem("SineWave");
        this.sourceChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterFun.this.selectSource(FilterFun.this.sourceChoice.getSelectedItem());
            }
        });
        return panel;
    }

    void selectSource(String sourceName) {
        System.out.println("Source is " + sourceName);
        if (sourceName.equals("WhiteNoise")) {
            this.useSource(this.whiteNoise, this.whiteNoise.amplitude, this.whiteNoise.output);
        } else if (sourceName.equals("PinkNoise")) {
            this.useSource(this.pinkNoise, this.pinkNoise.amplitude, this.pinkNoise.output);
        } else if (sourceName.equals("RedNoise")) {
            this.useSource(this.redNoise, this.redNoise.amplitude, this.redNoise.output);
        } else if (sourceName.equals("Impulse")) {
            this.useSource(this.impulse, this.impulse.amplitude, this.impulse.output);
        } else if (sourceName.equals("Sawtooth")) {
            this.useSource(this.sawtooth, this.sawtooth.amplitude, this.sawtooth.output);
        } else if (sourceName.equals("SineWave")) {
            this.useSource(this.sineosc, this.sineosc.amplitude, this.sineosc.output);
        } else {
            System.out.println("Unrecognized choice!" + sourceName);
        }
    }

    Panel makeFilterPanel() {
        Panel panel = new Panel();
        this.add(panel);
        panel.setBackground(filterColor);
        panel.add(new Label("Select Filter:"));
        this.filterChoice = new Choice();
        panel.add(this.filterChoice);
        this.filterChoice.addItem("LowPass");
        this.filterChoice.addItem("HighPass");
        this.filterChoice.addItem("BandPass");
        this.filterChoice.addItem("BandStop");
        this.filterChoice.addItem("PeakingEQ");
        this.filterChoice.addItem("LowShelf");
        this.filterChoice.addItem("HighShelf");
        this.filterChoice.addItem("StateVariable");
        this.filterChoice.addItem("BiQuad");
        this.filterChoice.addItem("OnePole");
        this.filterChoice.addItem("OneZero");
        this.filterChoice.addItem("OnePoleOneZero");
        this.filterChoice.addItem("TwoPole");
        this.filterChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterFun.this.selectFilter(FilterFun.this.filterChoice.getSelectedItem());
            }
        });
        return panel;
    }

    void selectFilter(String sourceName) {
        if (sourceName.equals("StateVariable")) {
            this.useFilter(this.funSVF);
        } else if (sourceName.equals("BiQuad")) {
            this.useFilter(this.funBiquad);
        } else if (sourceName.equals("OnePole")) {
            this.useFilter(this.fun1P);
        } else if (sourceName.equals("OneZero")) {
            this.useFilter(this.fun1Z);
        } else if (sourceName.equals("OnePoleOneZero")) {
            this.useFilter(this.fun1P1Z);
        } else if (sourceName.equals("TwoPole")) {
            this.useFilter(this.fun2P);
        } else if (sourceName.equals("LowPass")) {
            this.useFilter(this.funLowPass);
        } else if (sourceName.equals("HighPass")) {
            this.useFilter(this.funHighPass);
        } else if (sourceName.equals("BandPass")) {
            this.useFilter(this.funBandPass);
        } else if (sourceName.equals("BandStop")) {
            this.useFilter(this.funBandStop);
        } else if (sourceName.equals("PeakingEQ")) {
            this.useFilter(this.funPeakingEQ);
        } else if (sourceName.equals("LowShelf")) {
            this.useFilter(this.funLowShelf);
        } else if (sourceName.equals("HighShelf")) {
            this.useFilter(this.funHighShelf);
        } else {
            System.out.println("Unrecognized choice!" + sourceName);
        }
    }

    void stopAll() {
        if (this.currentSource != null) {
            this.currentSource.stop();
        }
        this.srcTap.stop();
        if (this.currentFilter != null) {
            this.currentFilter.stop();
        }
        this.filterTap.stop();
    }

    void startAll() {
        if (this.currentSource != null) {
            this.currentSource.start();
        }
        this.srcTap.start();
        if (this.currentFilter != null) {
            this.currentFilter.start();
        }
        this.filterTap.start();
    }

    void useSource(SynthUnit unit, SynthInput amplitude, SynthOutput output) {
        this.stopAll();
        this.currentSource = unit;
        this.currentSourceAmplitude = amplitude;
        this.currentSourceOutput = output;
        if (this.currentFilter != null) {
            this.currentSourceOutput.connect(this.currentFilter.input);
        }
        this.currentSourceOutput.connect(this.srcTap.inputA);
        this.freqFader.getFader().setEnabled(this.currentSource instanceof SynthOscillator);
        this.updateSource();
        this.startAll();
    }

    void updateSource() {
        if (this.currentSource == null) {
            return;
        }
        if (this.currentSource instanceof SynthOscillator) {
            ((SynthOscillator)this.currentSource).frequency.set(this.freqValue);
        }
        this.currentSourceAmplitude.set(this.ampValue);
    }

    void useFilter(FunFilter funFilter) {
        this.stopAll();
        this.currentFilter = funFilter.filter;
        if (this.currentSourceOutput != null) {
            this.currentSourceOutput.connect(this.currentFilter.input);
        }
        this.currentFilter.output.connect(this.filterTap.inputA);
        this.startAll();
        if (this.filterGUI != null) {
            this.filterGUI.removeAll();
            this.filterGUI.add("Center", funFilter);
            this.filterGUI.validate();
            this.getToolkit().sync();
        }
    }

    void buildSynth() {
        try {
            Synth.startEngine(0);
            this.whiteNoise = new WhiteNoise();
            this.pinkNoise = new PinkNoise();
            this.redNoise = new RedNoise();
            this.impulse = new ImpulseOscillator();
            this.sawtooth = new SawtoothOscillatorBL();
            this.sineosc = new SineOscillator();
            this.srcTap = new AddUnit();
            this.filterTap = new AddUnit();
            this.funBiquad = new FunBiquadFilter();
            this.funSVF = new FunSVFFilter();
            this.fun1Z = new Fun1ZFilter();
            this.fun1P = new Fun1PFilter();
            this.fun1P1Z = new Fun1P1ZFilter();
            this.fun2P = new Fun2PFilter();
            this.funLowPass = new FunLowPass();
            this.funHighPass = new FunHighPass();
            this.funBandPass = new FunBandPass();
            this.funBandStop = new FunBandStop();
            this.funPeakingEQ = new FunPeakingEQ();
            this.funLowShelf = new FunLowShelf();
            this.funHighShelf = new FunHighShelf();
            this.myOut = new LineOut();
            this.filterTap.output.connect(0, this.myOut.input, 0);
            this.filterTap.output.connect(0, this.myOut.input, 1);
            this.myOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void start() {
        this.buildSynth();
        this.buildGUI();
        this.selectSource(this.sourceChoice.getSelectedItem());
        this.selectFilter(this.filterChoice.getSelectedItem());
    }

    @Override
    public void stop() {
        try {
            this.whiteNoise.delete();
            this.pinkNoise.delete();
            this.redNoise.delete();
            this.impulse.delete();
            this.sawtooth.delete();
            this.sineosc.delete();
            this.srcTap.delete();
            this.filterTap.delete();
            this.funBiquad.delete();
            this.funSVF.delete();
            this.fun1Z.delete();
            this.fun1P.delete();
            this.fun1P1Z.delete();
            this.fun2P.delete();
            this.myOut.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 0: {
                this.freqValue = val;
                break;
            }
            case 1: {
                this.ampValue = val;
            }
        }
        this.updateSource();
    }

    class Fun1P1ZFilter
    extends FunFilter {
        Filter_1o1p1z fltr;

        public Fun1P1ZFilter() {
            this.fltr = new Filter_1o1p1z();
            this.filter = this.fltr;
            this.add(new PortFader(this.fltr.A0, 0.5, -1.0, 1.0));
            this.add(new PortFader(this.fltr.A1, 0.2, -1.0, 1.0));
            this.add(new PortFader(this.fltr.B1, 0.3, -1.0, 1.0));
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) + A1*x(n-1) - B1*y(n-1)";
        }
    }

    class Fun1PFilter
    extends FunFilter {
        Filter_1o1p f1o1p;

        public Fun1PFilter() {
            this.f1o1p = new Filter_1o1p();
            this.filter = this.f1o1p;
            this.add(new PortFader(this.f1o1p.A0, 0.6, -1.0, 1.0));
            this.add(new PortFader(this.f1o1p.B1, 0.3, -1.0, 1.0));
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) - B1*y(n-1)";
        }
    }

    class Fun1ZFilter
    extends FunFilter {
        Filter_1o1z f1o1z;

        public Fun1ZFilter() {
            this.f1o1z = new Filter_1o1z();
            this.filter = this.f1o1z;
            this.add(new PortFader(this.f1o1z.A0, 0.5, -1.0, 1.0));
            this.add(new PortFader(this.f1o1z.A1, 0.5, -1.0, 1.0));
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) + A1*x(n-1)";
        }
    }

    class Fun2PFilter
    extends FunFilter {
        Filter_2o2p fltr;

        public Fun2PFilter() {
            this.fltr = new Filter_2o2p();
            this.filter = this.fltr;
            this.add(new PortFader(this.fltr.A0, 0.5, -1.0, 1.0));
            this.add(new PortFader(this.fltr.B1, 0.2, -1.0, 1.0));
            this.add(new PortFader(this.fltr.B2, 0.3, -1.0, 1.0));
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) - B1*y(n-1) - B2*y(n-2)";
        }
    }

    class FunBandPass
    extends FunTunable {
        public FunBandPass() {
            this.filter = new Filter_BandPass();
            this.setupFaders();
        }
    }

    class FunBandStop
    extends FunTunable {
        public FunBandStop() {
            this.filter = new Filter_BandStop();
            this.setupFaders();
        }
    }

    class FunBiquadFilter
    extends FunParametric
    implements Tweakable {
        LabelledFader gainFader;
        LabelledFader slopeFader;
        Filter_2o2p2z biquad;
        int passIndex;

        public FunBiquadFilter() {
            this.passIndex = 0;
            this.biquad = new Filter_2o2p2z();
            this.filter = this.biquad;
            this.gainFader = new LabelledFader(this, 2, "dB Gain", FilterFun.this.dBGainValue, -80.0, 80.0);
            this.add(this.gainFader);
            this.slopeFader = new LabelledFader(this, 3, "slope", FilterFun.this.slopeValue, 0.01, 2.0);
            this.add(this.slopeFader);
            this.passChoice.addItem("Notch");
            this.passChoice.addItem("Peaking EQ");
            this.passChoice.addItem("Low Shelf");
            this.passChoice.addItem("High Shelf");
            this.updateFilter();
        }

        @Override
        public String getEquation() {
            return "y(n) = 2.0 * (A0*x(n) + A1*x(n-1) + A2*x(n-2) - B1*y(n-1) - B2*y(n-2))";
        }

        @Override
        public void setPass(int passIndex) {
            this.passIndex = passIndex;
            this.updateFilter();
        }

        @Override
        public void updateFilter() {
            switch (this.passChoice.getSelectedIndex()) {
                case 0: {
                    this.biquad.lowPass(FilterFun.this.cutoffValue, FilterFun.this.bandwidthValue);
                    break;
                }
                case 1: {
                    this.biquad.bandPass(FilterFun.this.cutoffValue, FilterFun.this.bandwidthValue);
                    break;
                }
                case 2: {
                    this.biquad.highPass(FilterFun.this.cutoffValue, FilterFun.this.bandwidthValue);
                    break;
                }
                case 3: {
                    this.biquad.notch(FilterFun.this.cutoffValue, FilterFun.this.bandwidthValue);
                    break;
                }
                case 4: {
                    this.biquad.peakingEQ(FilterFun.this.cutoffValue, FilterFun.this.bandwidthValue, FilterFun.this.dBGainValue);
                    break;
                }
                case 5: {
                    this.biquad.lowShelf(FilterFun.this.cutoffValue, FilterFun.this.dBGainValue, FilterFun.this.slopeValue);
                    break;
                }
                case 6: {
                    this.biquad.highShelf(FilterFun.this.cutoffValue, FilterFun.this.dBGainValue, FilterFun.this.slopeValue);
                }
            }
        }
    }

    abstract class FunFilter
    extends Panel {
        public SynthFilter filter;

        public FunFilter() {
            this.setLayout(new GridLayout(0, 1));
            this.add(new Label(this.getEquation(), 1));
        }

        void delete() {
            this.filter.delete();
        }

        public abstract String getEquation();
    }

    class FunHighPass
    extends FunTunable {
        public FunHighPass() {
            this.filter = new Filter_HighPass();
            this.setupFaders();
        }
    }

    class FunHighShelf
    extends FunFilter {
        PortFader cutoffFader;
        PortFader gainFader;
        PortFader slopeFader;

        public FunHighShelf() {
            this.filter = new Filter_HighShelf();
            this.cutoffFader = new ExponentialPortFader(((Filter_HighShelf)this.filter).frequency, 400.0, 10.0, 10000.0);
            this.add(this.cutoffFader);
            this.gainFader = new ExponentialPortFader(((Filter_HighShelf)this.filter).gain, 1.0, 0.001, 10.0);
            this.add(this.gainFader);
            this.slopeFader = new PortFader(((Filter_HighShelf)this.filter).slope, 1.0, 0.001, 2.0);
            this.add(this.slopeFader);
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) + A1*x(n-1) + A2*x(n-2) - B1*y(n-1) - B2*y(n-2)";
        }
    }

    class FunLowPass
    extends FunTunable {
        public FunLowPass() {
            this.filter = new Filter_LowPass();
            this.setupFaders();
        }
    }

    class FunLowShelf
    extends FunFilter {
        PortFader cutoffFader;
        PortFader gainFader;
        PortFader slopeFader;

        public FunLowShelf() {
            this.filter = new Filter_LowShelf();
            this.cutoffFader = new ExponentialPortFader(((Filter_LowShelf)this.filter).frequency, 400.0, 10.0, 10000.0);
            this.add(this.cutoffFader);
            this.gainFader = new ExponentialPortFader(((Filter_LowShelf)this.filter).gain, 1.0, 0.001, 10.0);
            this.add(this.gainFader);
            this.slopeFader = new PortFader(((Filter_LowShelf)this.filter).slope, 1.0, 0.001, 2.0);
            this.add(this.slopeFader);
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) + A1*x(n-1) + A2*x(n-2) - B1*y(n-1) - B2*y(n-2)";
        }
    }

    abstract class FunParametric
    extends FunFilter
    implements Tweakable {
        LabelledFader cutoffFader;
        LabelledFader widthFader;
        Choice passChoice;

        public FunParametric() {
            this.cutoffFader = new LabelledFader(this, 0, "Cutoff Frequency", FilterFun.this.cutoffValue, 10.0, 10000.0);
            this.add(this.cutoffFader);
            this.widthFader = new LabelledFader(this, 1, "Bandwidth", FilterFun.this.bandwidthValue, 0.001, 0.5);
            this.add(this.widthFader);
            this.passChoice = new Choice();
            this.add(this.passChoice);
            this.passChoice.addItem("Low Pass");
            this.passChoice.addItem("Band Pass");
            this.passChoice.addItem("High Pass");
            this.passChoice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FunParametric.this.setPass(FunParametric.this.passChoice.getSelectedIndex());
                }
            });
        }

        @Override
        public void tweak(int targetIndex, double val) {
            switch (targetIndex) {
                case 0: {
                    FilterFun.this.cutoffValue = val;
                    this.updateFilter();
                    break;
                }
                case 1: {
                    FilterFun.this.bandwidthValue = val;
                    this.updateFilter();
                    break;
                }
                case 2: {
                    FilterFun.this.dBGainValue = val;
                    this.updateFilter();
                    break;
                }
                case 3: {
                    FilterFun.this.slopeValue = val;
                    this.updateFilter();
                }
            }
        }

        public abstract void setPass(int var1);

        public abstract void updateFilter();
    }

    class FunPeakingEQ
    extends FunTunable {
        PortFader gainFader;

        public FunPeakingEQ() {
            this.filter = new Filter_PeakingEQ();
            this.setupFaders();
            this.gainFader = new ExponentialPortFader(((Filter_PeakingEQ)this.filter).gain, 1.0, 0.001, 10.0);
            this.add(this.gainFader);
        }
    }

    class FunSVFFilter
    extends FunParametric
    implements Tweakable {
        Filter_StateVariable svf = new Filter_StateVariable();

        public FunSVFFilter() {
            this.filter = this.svf;
            this.updateFilter();
        }

        @Override
        public String getEquation() {
            return "State Variable Filter as described by Hal Chamberlain";
        }

        @Override
        public void setPass(int passIndex) {
            switch (passIndex) {
                case 0: {
                    this.svf.lowPass.connect(FilterFun.this.filterTap.inputA);
                    break;
                }
                case 1: {
                    this.svf.bandPass.connect(FilterFun.this.filterTap.inputA);
                    break;
                }
                case 2: {
                    this.svf.highPass.connect(FilterFun.this.filterTap.inputA);
                }
            }
        }

        @Override
        public void updateFilter() {
            this.svf.frequency.set(FilterFun.this.cutoffValue);
            this.svf.resonance.set(FilterFun.this.bandwidthValue);
        }
    }

    abstract class FunTunable
    extends FunFilter {
        PortFader cutoffFader;
        PortFader QFader;

        FunTunable() {
        }

        void setupFaders() {
            TunableFilter tf = (TunableFilter)this.filter;
            this.cutoffFader = new ExponentialPortFader(tf.frequency, 400.0, 10.0, 10000.0);
            this.add(this.cutoffFader);
            this.QFader = new PortFader(tf.Q, 1.0, 0.001, 10.0);
            this.add(this.QFader);
        }

        @Override
        public String getEquation() {
            return "y(n) = A0*x(n) + A1*x(n-1) + A2*x(n-2) - B1*y(n-1) - B2*y(n-2)";
        }
    }
}

