/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.util.HarmonicTable;

class FilteredSawEnv
extends SynthNote {
    HarmonicTable myTable;
    TableOscillator myOsc = new TableOscillator();
    Filter_StateVariable myFilter;
    SynthEnvelope ampEnv;
    EnvelopePlayer ampEnvPlayer;
    EnvelopePlayer freqEnvPlayer;
    SynthEnvelope[] envelopes;
    MultiplyUnit freqScalar;
    static final int NUM_HARMONICS = 12;
    static final int WAVE_LENGTH = 512;
    static final int NUM_ENVELOPES = 3;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthInput rate;

    public FilteredSawEnv() throws SynthException {
        this.add(this.myOsc);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.ampEnvPlayer = new EnvelopePlayer();
        this.add(this.ampEnvPlayer);
        this.freqEnvPlayer = new EnvelopePlayer();
        this.add(this.freqEnvPlayer);
        this.freqScalar = new MultiplyUnit();
        this.add(this.freqScalar);
        this.myTable = new HarmonicTable(513, 12);
        this.myOsc.tablePort.setTable(this.myTable);
        this.myTable.sawtooth();
        this.envelopes = new SynthEnvelope[3];
        double[] data0 = new double[]{0.1, 0.9, 0.1, 0.5, 0.1, 0.7, 0.1, 0.2};
        this.envelopes[0] = new SynthEnvelope(data0);
        double[] data1 = new double[]{0.1, 0.1, 0.4, 0.5, 0.1, 0.0, 0.1, 0.9};
        this.envelopes[1] = new SynthEnvelope(data1);
        double[] data2 = new double[]{0.1, 0.8, 0.4, 0.5, 0.02, 0.0, 0.02, 0.8, 0.02, 0.0, 0.1, 0.4};
        this.envelopes[2] = new SynthEnvelope(data2);
        double[] ampData = new double[]{0.02, 0.2, 0.05, 0.8, 0.05, 1.0, 0.3, 0.8, 0.1, 0.7, 0.1, 0.2, 0.1, 0.0, 0.2, 0.0};
        this.ampEnv = new SynthEnvelope(ampData);
        this.freqEnvPlayer.output.connect(this.freqScalar.inputA);
        this.freqScalar.output.connect(this.myFilter.frequency);
        this.myOsc.output.connect(this.ampEnvPlayer.amplitude);
        this.ampEnvPlayer.output.connect(this.myFilter.input);
        this.frequency = this.myOsc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.myOsc.amplitude;
        this.addPort(this.amplitude);
        this.cutoff = this.freqScalar.inputB;
        this.addPort(this.cutoff, "cutoff");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.rate = this.freqEnvPlayer.rate;
        this.addPort(this.rate);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.amplitude.setup(0.0, 0.3, 1.0);
        this.frequency.setup(0.0, 160.0, 2000.0);
        this.cutoff.setup(0.0, 2000.0, 8000.0);
        this.resonance.setup(0.0, 0.2, 0.9);
        this.rate.set(1.0);
    }

    public void attack() {
        this.ampEnvPlayer.envelopePort.queue(this.ampEnv, 0, 3);
    }

    public void release() {
        this.ampEnvPlayer.envelopePort.queue(this.ampEnv, 4, 3);
    }

    public void loop() {
        this.ampEnvPlayer.envelopePort.queueLoop(this.ampEnv);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        this.freqEnvPlayer.envelopePort.queueLoop(time, this.envelopes[stage]);
    }
}

