/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.WaveShaper;
import com.softsynth.jsyn.view102.SynthScope;
import com.softsynth.tools.view.JAppletFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;

public class TJ_Birds
extends JApplet {
    int numBirds;
    CozumelBird[] birds;
    JButton[] buttons;
    BusReader unitBusReader;
    LineOut unitOut;
    SynthScope scope;
    Dialog scopeDialog;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_Birds applet = new TJ_Birds();
        JAppletFrame frame = new JAppletFrame("Birds", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public String getAppletInfo() {
        return "(C) 1997 Phil Burk, updated 11/14/07";
    }

    @Override
    public void start() {
        this.getContentPane().setLayout(new GridLayout(0, 1));
        try {
            Synth.requestVersion(142);
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.unitBusReader = new BusReader(this.synthContext);
            this.unitOut = new LineOut(this.synthContext);
            this.unitBusReader.setPriority(0);
            this.unitBusReader.output.connect(0, this.unitOut.input, 0);
            this.unitBusReader.output.connect(0, this.unitOut.input, 1);
            this.numBirds = 5;
            this.birds = new CozumelBird[this.numBirds];
            this.buttons = new JButton[this.numBirds];
            int i = 0;
            while (i < this.numBirds) {
                this.birds[i] = new CozumelBird(this.synthContext, this.unitBusReader.busInput, 1000.0 + 4000.0 * (double)i / (double)(this.numBirds + 1));
                this.birds[i].start();
                this.buttons[i] = new JButton("Bird" + i);
                this.getContentPane().add(this.buttons[i]);
                this.buttons[i].addActionListener(new ChirpListener(this.birds[i]));
                ++i;
            }
            this.scope = new SynthScope(this.synthContext, 4096);
            this.scope.createProbe(this.unitBusReader.output, "BusOut", Color.yellow);
            this.scope.finish();
            this.scopeDialog = new Dialog(SynthAlert.getFrame(this), "JSyn Scope");
            this.scopeDialog.add("Center", this.scope);
            this.scopeDialog.setBounds(200, 200, 600, 500);
            this.scopeDialog.show();
            this.getParent().validate();
            this.getToolkit().sync();
            this.unitBusReader.start();
            this.unitOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        this.scopeDialog.hide();
        this.removeAll();
        try {
            int i = 0;
            while (i < this.numBirds) {
                this.birds[i].delete();
                ++i;
            }
            this.unitBusReader.delete();
            this.unitOut.delete();
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class ChirpListener
    implements ActionListener {
        CozumelBird bird;

        public ChirpListener(CozumelBird bird) {
            this.bird = bird;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.bird.chirp();
            }
            catch (SynthException exc) {
                exc.printStackTrace();
            }
        }
    }

    class CozumelBird
    extends SynthCircuit {
        TriangleOscillator unitOsc;
        SynthOscillator unitLFO1;
        ExponentialLag unitLagAmp;
        MultiplyAddUnit unitFreqMix;
        WaveShaper unitWaveShaper;
        BusWriter unitBusWriter;
        SynthTable tableMod2Amp;
        SynthBusInput bus;
        double topFreq;

        public CozumelBird(SynthContext synthContext, SynthBusInput bus, double topFreq) throws SynthException {
            super(synthContext);
            this.topFreq = topFreq;
            this.bus = bus;
            this.unitOsc = new TriangleOscillator(synthContext);
            this.add(this.unitOsc);
            this.unitLFO1 = new SawtoothOscillatorBL(synthContext);
            this.add(this.unitLFO1);
            this.unitLagAmp = new ExponentialLag(synthContext);
            this.add(this.unitLagAmp);
            this.unitFreqMix = new MultiplyAddUnit(synthContext);
            this.add(this.unitFreqMix);
            this.unitBusWriter = new BusWriter(synthContext);
            this.add(this.unitBusWriter);
            this.unitWaveShaper = new WaveShaper(synthContext);
            this.add(this.unitWaveShaper);
            double[] data = new double[]{0.0, 1.0, 0.0};
            this.tableMod2Amp = new SynthTable(synthContext, data);
            this.unitWaveShaper.tablePort.setTable(this.tableMod2Amp);
            this.unitLFO1.output.connect(this.unitWaveShaper.input);
            this.unitLagAmp.halfLife.set(0.1);
            this.unitLagAmp.output.connect(this.unitWaveShaper.amplitude);
            this.unitWaveShaper.output.connect(this.unitOsc.amplitude);
            this.unitLFO1.output.connect(this.unitFreqMix.inputA);
            this.unitFreqMix.output.connect(this.unitOsc.frequency);
            this.unitBusWriter.busOutput.connect(bus);
            this.unitOsc.output.connect(this.unitBusWriter.input);
            this.compile();
        }

        public void chirp() throws SynthException {
            int dur = 100;
            int ticks = this.getSynthContext().getTickCount();
            int i = 0;
            while (i < 6) {
                this.unitLagAmp.input.set(ticks, 0.5);
                this.unitLFO1.frequency.set(ticks, 50.0 * (Math.random() * (Math.random() - 0.5)));
                this.unitFreqMix.inputB.set(ticks, 600.0 * Math.random() + 100.0);
                this.unitFreqMix.inputC.set(ticks, 0.5 * this.topFreq * (Math.random() + 1.0));
                ticks = (int)((double)ticks + (double)dur * (Math.random() + 0.5));
                this.unitLagAmp.input.set(ticks, 0.0);
                ticks = (int)((double)ticks + (double)dur * (Math.random() + 0.5));
                ++i;
            }
        }
    }
}

