/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.AudioDevice;
import com.softsynth.jsyn.ChannelIn;
import com.softsynth.jsyn.ChannelOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthUnit;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

public class TJ_Devices
extends Applet {
    SynthContext synthContext;
    ChannelIn[] inputs;
    ChannelOut[] outputs;
    SineOscillator[] sines;
    DeviceSelector inDevSel;
    DeviceSelector outDevSel;
    Button startButton;
    Button stopButton;
    public static final int INPUT_MODE = 0;
    public static final int OUTPUT_MODE = 1;

    public static void main(String[] args) {
        System.out.println("user.home = " + System.getProperty("user.home"));
        TJ_Devices applet = new TJ_Devices();
        AppletFrame frame = new AppletFrame("Test JSyn Devices", applet);
        frame.resize(600, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        System.out.println("java.library.path = " + System.getProperty("java.library.path"));
        this.setLayout(new BorderLayout());
        Panel centerPanel = new Panel();
        centerPanel.setLayout(new GridLayout(2, 1));
        this.add("Center", centerPanel);
        Synth.requestVersion(144);
        try {
            this.synthContext = new SynthContext();
            this.synthContext.initialize();
            int defId = AudioDevice.getDefaultOutputDeviceID();
            System.out.println("default output device ID = " + defId);
            int maxChannels = AudioDevice.getMaxOutputChannels(defId);
            System.out.println("max output channels = " + maxChannels);
            this.inDevSel = new DeviceSelector("Input", 0);
            centerPanel.add(this.inDevSel);
            this.outDevSel = new DeviceSelector("Output", 1);
            centerPanel.add(this.outDevSel);
            Panel bottomPanel = new Panel();
            bottomPanel.setLayout(new GridLayout(1, 2));
            this.add("South", bottomPanel);
            this.startButton = new Button("Start");
            bottomPanel.add(this.startButton);
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Devices.this.stopAudio();
                    TJ_Devices.this.startAudio();
                }
            });
            this.stopButton = new Button("Stop");
            bottomPanel.add(this.stopButton);
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_Devices.this.stopAudio();
                }
            });
            this.stopButton.setEnabled(false);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void startAudio() {
        try {
            int numOut;
            int i;
            this.synthContext.setSuggestedInputLatency((double)this.inDevSel.getSuggestedLatencyMSec() * 0.001);
            this.synthContext.setSuggestedOutputLatency((double)this.outDevSel.getSuggestedLatencyMSec() * 0.001);
            int inDevID = this.inDevSel.getDeviceID();
            int outDevID = this.outDevSel.getDeviceID();
            this.synthContext.start(0, 48000.0, inDevID, this.inDevSel.getNumChannels(inDevID), outDevID, this.outDevSel.getNumChannels(outDevID));
            int numIn = this.inDevSel.getNumChannels(inDevID);
            if (numIn > 0) {
                this.inputs = new ChannelIn[numIn];
                i = 0;
                while (i < numIn) {
                    this.inputs[i] = new ChannelIn(this.synthContext, i);
                    this.inputs[i].start();
                    ++i;
                }
            }
            if ((numOut = this.outDevSel.getNumChannels(outDevID)) > 0) {
                this.outputs = new ChannelOut[numOut];
                if (numIn <= 0) {
                    this.sines = new SineOscillator[numOut];
                }
                i = 0;
                while (i < numOut) {
                    this.outputs[i] = new ChannelOut(this.synthContext, i);
                    this.outputs[i].start();
                    if (numIn > 0) {
                        this.inputs[i % numIn].output.connect(this.outputs[i].input);
                    } else {
                        this.sines[i] = new SineOscillator(this.synthContext);
                        this.sines[i].frequency.set(200.0 * (double)(i + 1));
                        this.sines[i].amplitude.set(1.0);
                        this.sines[i].start();
                        this.sines[i].output.connect(this.outputs[i].input);
                    }
                    ++i;
                }
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.inDevSel.started();
        this.outDevSel.started();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.stopAudio();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void killUnits(SynthUnit[] units) {
        if (units != null) {
            int i = 0;
            while (i < units.length) {
                units[i].stop();
                units[i].delete();
                ++i;
            }
        }
    }

    void stopAudio() {
        this.inDevSel.stopped();
        this.outDevSel.stopped();
        this.killUnits(this.outputs);
        this.outputs = null;
        this.killUnits(this.inputs);
        this.inputs = null;
        this.killUnits(this.sines);
        this.sines = null;
        this.synthContext.stop();
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.getParent().validate();
        this.getToolkit().sync();
    }

    class DeviceMenuItem {
        String name;
        int maxChannels;
        int devID;

        DeviceMenuItem(int pDevID, String pName, int pMaxChannels) {
            this.devID = pDevID;
            this.name = pName;
            this.maxChannels = pMaxChannels;
        }

        public String toString() {
            return String.valueOf(this.name) + " [" + this.maxChannels + "]";
        }

        int getDeviceID() {
            return this.devID;
        }
    }

    class DeviceSelector
    extends Panel {
        String text;
        Label currentNameLabel;
        Label currentLatencyLabel;
        Choice deviceNames;
        Checkbox devEnable;
        TextField numChannelText;
        TextField suggestedLatencyText;
        int mode;
        Hashtable namesToDevice;
        private static final String ACTUAL_LATENCY_TEXT = "Actual Latency (msec) = ";

        public DeviceSelector(String text, int mode) {
            this.text = text;
            this.mode = mode;
            this.namesToDevice = new Hashtable();
            this.setLayout(new GridLayout(2, 1));
            Panel topPanel = new Panel();
            this.devEnable = new Checkbox(text, mode == 1);
            topPanel.add(this.devEnable);
            this.deviceNames = new Choice();
            topPanel.add(this.deviceNames);
            int defaultDeviceID = mode == 1 ? AudioDevice.getDefaultOutputDeviceID() : AudioDevice.getDefaultInputDeviceID();
            int defaultSelection = 0;
            int i = 0;
            while (i < AudioDevice.getNumDevices()) {
                int maxChannels = this.getMaxChannels(i);
                if (maxChannels > 0) {
                    DeviceMenuItem item = new DeviceMenuItem(i, AudioDevice.getName(i), maxChannels);
                    this.deviceNames.addItem(item.toString());
                    this.namesToDevice.put(item.toString(), item);
                    if (i == defaultDeviceID) {
                        defaultSelection = this.deviceNames.getItemCount() - 1;
                    }
                }
                ++i;
            }
            if (this.deviceNames.getItemCount() > 0) {
                this.deviceNames.select(defaultSelection);
            }
            topPanel.add(new Label("Channels to use ="));
            this.numChannelText = new TextField("2", 2);
            topPanel.add(this.numChannelText);
            this.currentNameLabel = new Label("Stopped");
            topPanel.add(this.currentNameLabel);
            this.add(topPanel);
            Panel bottomPanel = new Panel();
            bottomPanel.add(new Label("Suggested Latency (msec) ="));
            this.suggestedLatencyText = new TextField("100", 8);
            bottomPanel.add(this.suggestedLatencyText);
            this.currentLatencyLabel = new Label("Actual (msec) = ?");
            bottomPanel.add(this.currentLatencyLabel);
            this.add(bottomPanel);
        }

        public void started() {
            if (this.devEnable.getState()) {
                this.currentNameLabel.setText("Started");
                double latency = this.mode == 0 ? TJ_Devices.this.synthContext.getInputLatency() : TJ_Devices.this.synthContext.getOutputLatency();
                int msec = (int)Math.round(latency * 1000.0);
                this.currentLatencyLabel.setText(ACTUAL_LATENCY_TEXT + msec);
                this.validate();
            }
            this.numChannelText.setEnabled(false);
            this.suggestedLatencyText.setEnabled(false);
        }

        public void stopped() {
            this.currentNameLabel.setText("Stopped");
            this.currentLatencyLabel.setText("Actual Latency (msec) = ?");
            this.numChannelText.setEnabled(true);
            this.suggestedLatencyText.setEnabled(true);
        }

        public int getMaxChannels(int id) {
            int maxChannels = this.mode == 0 ? AudioDevice.getMaxInputChannels(id) : AudioDevice.getMaxOutputChannels(id);
            return maxChannels;
        }

        public void setNumChannels(int numChannels) {
            this.numChannelText.setText("" + numChannels);
        }

        public int getSuggestedLatencyMSec() {
            int val = 100;
            try {
                val = Integer.parseInt(this.suggestedLatencyText.getText());
            }
            catch (NumberFormatException e) {
                this.suggestedLatencyText.setText("" + val);
            }
            return val;
        }

        private int parseChannelText() {
            int val = 2;
            try {
                val = Integer.parseInt(this.numChannelText.getText());
            }
            catch (NumberFormatException e) {
                this.setNumChannels(val);
            }
            return val;
        }

        public int getNumChannels(int id) {
            int numChannels = 0;
            if (id != -1) {
                numChannels = this.parseChannelText();
                int maxChannels = this.getMaxChannels(id);
                if (numChannels <= 0 || numChannels > maxChannels) {
                    numChannels = maxChannels;
                    this.setNumChannels(numChannels);
                }
            }
            return numChannels;
        }

        public int getSelectedDeviceID() {
            DeviceMenuItem item = (DeviceMenuItem)this.namesToDevice.get(this.deviceNames.getSelectedItem());
            return item.getDeviceID();
        }

        public int getDeviceID() {
            return this.devEnable.getState() ? this.getSelectedDeviceID() : -1;
        }
    }
}

