/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.examples.Noodler;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Label;
import java.util.Vector;

public class TJ_Noodler
extends Applet {
    Vector myNoodlers;
    Button startOne;
    Button stopOne;
    Label showNumNoodlers;

    public static void main(String[] args) {
        TJ_Noodler applet = new TJ_Noodler();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.myNoodlers = new Vector();
            this.startOne = new Button("StartAnother");
            this.add(this.startOne);
            this.stopOne = new Button("StopOne");
            this.add(this.stopOne);
            this.add(new UsageDisplay());
            this.showNumNoodlers = new Label("Num = 0");
            this.add(this.showNumNoodlers);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        int i = 0;
        while (i < this.myNoodlers.size()) {
            Noodler nood = (Noodler)this.myNoodlers.elementAt(i);
            nood.die();
            ++i;
        }
        System.out.println("Wait for noodlers to finish.");
        while (!this.myNoodlers.isEmpty()) {
            Noodler nood = (Noodler)this.myNoodlers.firstElement();
            try {
                nood.join();
            }
            catch (InterruptedException e) {
                System.err.println("Caught " + e);
            }
            this.myNoodlers.removeElement(nood);
        }
        Synth.stopEngine();
    }

    public void calcNewAmp() {
        int numNoodlers = this.myNoodlers.size();
        Noodler.setMaxAmp(1.0 / (double)numNoodlers);
        this.showNumNoodlers.setText("Num = " + this.myNoodlers.size());
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.startOne) {
            Noodler nood = new Noodler();
            this.myNoodlers.addElement(nood);
            this.calcNewAmp();
            nood.start();
            return true;
        }
        if (evt.target == this.stopOne) {
            int numNoodlers = this.myNoodlers.size();
            if (numNoodlers == 0) {
                return true;
            }
            int noodlerVictim = (int)(Math.random() * (double)numNoodlers);
            Noodler nood = (Noodler)this.myNoodlers.elementAt(noodlerVictim);
            nood.die();
            this.myNoodlers.removeElement(nood);
            this.calcNewAmp();
            return true;
        }
        return false;
    }
}

