/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.circuits.RingModBell;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TJ_PlayKeys1
extends Applet
implements KeyListener {
    PitchedVoices ringVoices;
    String ringKeys = "qwertyuiop";
    LineOut lineOut;
    LineOut lineOutRec;
    double[] pentatonic;
    StereoRecorder recorder;
    Button keyButton;
    BussedVoiceAllocator voiceAllocator;
    int lastKeyDown = -1;

    public static void main(String[] args) {
        TJ_PlayKeys1 applet = new TJ_PlayKeys1();
        AppletFrame frame = new AppletFrame("Play ASCII keyboard.", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    double[] buildPentatonic(int numNotes, double fundamental) {
        double[] scale = new double[]{1.0, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667};
        double[] freqs = new double[numNotes];
        int i = 0;
        while (i < numNotes) {
            int octave = i / 5;
            int pitch = i % 5;
            freqs[i] = scale[pitch] * fundamental * (double)(1 << octave);
            ++i;
        }
        return freqs;
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        this.pentatonic = this.buildPentatonic(this.ringKeys.length(), 400.0);
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.voiceAllocator = new BussedVoiceAllocator(4){

                @Override
                public SynthCircuit makeVoice() throws SynthException {
                    RingModBell circ = new RingModBell();
                    return this.addVoiceToMix(circ);
                }
            };
            this.ringVoices = new PitchedVoices(this.voiceAllocator, this.pentatonic);
            this.lineOut = new LineOut();
            this.voiceAllocator.output.connect(0, this.lineOut.input, 0);
            this.lineOut.start();
            this.recorder = new StereoRecorder(5.0);
            this.recorder.start();
            this.voiceAllocator.getOutput().connect(0, this.recorder.input, 0);
            this.recorder.output.connect(0, this.recorder.input, 1);
            this.lineOutRec = new LineOut();
            this.lineOutRec.start();
            this.recorder.output.connect(0, this.lineOutRec.input, 0);
            this.recorder.output.connect(1, this.lineOutRec.input, 1);
            this.keyButton = new Button("Activate Keyboard");
            this.add(this.keyButton);
            this.keyButton.addKeyListener(this);
            this.add(new Label("RingMod: " + this.ringKeys));
            this.add(new UsageDisplay());
            this.add(this.recorder.buildGUI());
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.lineOut.delete();
        this.lineOut = null;
        this.voiceAllocator.stop();
        this.voiceAllocator.delete();
        this.voiceAllocator = null;
        this.removeAll();
        Synth.verbosity = 0;
        Synth.stopEngine();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        System.out.println("key pressed = " + key);
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            int idx = this.ringKeys.indexOf(key);
            if (idx >= 0) {
                this.ringVoices.noteOn(idx, 0.2);
            } else if (key == 'g') {
                System.out.println("Garbage collect!");
                Runtime.getRuntime().gc();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (this.lastKeyDown != -1) {
            this.lastKeyDown = -1;
            int idx = this.ringKeys.indexOf(key);
            if (idx >= 0) {
                this.ringVoices.noteOff(idx);
            }
        }
    }

    class PitchedVoices {
        BussedVoiceAllocator allocator;
        SynthNote[] voices;
        SynthNote voice;
        double[] frequencies;
        int numPitches;

        public PitchedVoices(BussedVoiceAllocator allocator, double[] frequencies) {
            this.allocator = allocator;
            this.frequencies = frequencies;
            this.numPitches = frequencies.length;
            this.voices = new SynthNote[this.numPitches];
        }

        public void noteOn(int pitchIndex, double amplitude) {
            if (this.voices[pitchIndex] != null) {
                this.noteOff(pitchIndex);
            }
            this.voices[pitchIndex] = this.voice = (SynthNote)this.allocator.steal();
            this.voice.noteOn(Synth.getTickCount(), this.frequencies[pitchIndex], amplitude);
        }

        public void noteOff(int pitchIndex) {
            this.voice = this.voices[pitchIndex];
            if (this.voice != null) {
                this.voice.noteOff(Synth.getTickCount());
                this.voices[pitchIndex] = null;
                this.allocator.free(this.voice);
            }
        }
    }

    class StereoRecorder
    extends SynthCircuit {
        SynthSample stereoSample;
        SampleWriter_16F2 sampleWriter;
        SampleReader_16F2 sampleReader;
        SynthInput input;
        Button recordButton;
        Button recordLoopButton;
        Button recordStopButton;
        Button playButton;
        Button playLoopButton;
        Button playStopButton;

        public StereoRecorder(double seconds) {
            this.stereoSample = new SynthSample((int)(Synth.getFrameRate() * seconds), 2);
            this.sampleWriter = new SampleWriter_16F2();
            this.add(this.sampleWriter);
            this.sampleReader = new SampleReader_16F2();
            this.add(this.sampleReader);
            this.input = this.sampleWriter.input;
            this.addPort(this.input);
            this.output = this.sampleReader.output;
            this.addPort(this.output);
        }

        public Panel buildGUI() {
            Panel panel = new Panel();
            this.recordButton = new Button("Record");
            panel.add(this.recordButton);
            this.recordButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.record();
                }
            });
            this.recordLoopButton = new Button("RecordLoop");
            panel.add(this.recordLoopButton);
            this.recordLoopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.recordLoop();
                }
            });
            this.recordStopButton = new Button("RecordStop");
            panel.add(this.recordStopButton);
            this.recordStopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.recordStop();
                }
            });
            this.playButton = new Button("Play");
            panel.add(this.playButton);
            this.playButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.play();
                }
            });
            this.playLoopButton = new Button("PlayLoop");
            panel.add(this.playLoopButton);
            this.playLoopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.playLoop();
                }
            });
            this.playStopButton = new Button("PlayStop");
            panel.add(this.playStopButton);
            this.playStopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StereoRecorder.this.playStop();
                }
            });
            return panel;
        }

        public void record() {
            this.sampleWriter.samplePort.queue(this.stereoSample);
        }

        public void recordLoop() {
            this.sampleWriter.samplePort.queueLoop(this.stereoSample);
        }

        public void recordStop() {
            this.sampleWriter.samplePort.clear();
        }

        public void play() {
            this.sampleReader.samplePort.queue(this.stereoSample);
        }

        public void playLoop() {
            this.sampleReader.samplePort.queueLoop(this.stereoSample);
        }

        public void playStop() {
            this.sampleReader.samplePort.clear();
        }
    }
}

