/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PulseOscillator;
import com.softsynth.jsyn.PulseOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;

public class TJ_PulseFader
extends Applet {
    PulseOscillatorBL myOscBL;
    PulseOscillator myOsc;
    SynthDistributor amplitude;
    SynthDistributor width;
    LineOut myOut;
    TriangleOscillator myLFO;
    AddUnit mySum;
    SynthScope scope;
    Dialog dialog;

    public static void main(String[] args) {
        TJ_PulseFader applet = new TJ_PulseFader();
        AppletFrame frame = new AppletFrame("Test Java Synthesis", applet);
        frame.resize(400, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.myOscBL = new PulseOscillatorBL();
            this.myOsc = new PulseOscillator();
            this.myLFO = new TriangleOscillator();
            this.mySum = new AddUnit();
            this.myOut = new LineOut();
            this.amplitude = new SynthDistributor("Amplitude");
            this.width = new SynthDistributor("PulseWidth");
            this.amplitude.connect(this.myOsc.amplitude);
            this.amplitude.connect(this.myOscBL.amplitude);
            this.width.connect(this.myOsc.width);
            this.width.connect(this.myOscBL.width);
            this.myLFO.output.connect(this.mySum.inputA);
            this.mySum.output.connect(this.myOsc.frequency);
            this.mySum.output.connect(this.myOscBL.frequency);
            this.myOsc.output.connect(0, this.myOut.input, 0);
            this.myOscBL.output.connect(0, this.myOut.input, 1);
            this.add(new PortFader(this.amplitude, 0.5, 0.0, 0.999));
            this.add(new PortFader(this.width, 0.0, -1.0, 1.0));
            this.add(new PortFader(this.myLFO.frequency, "ModRate", 3.0, 0.0, 20.0));
            this.add(new PortFader(this.myLFO.amplitude, "ModDepth", 300.0, 0.0, 1000.0));
            this.add(new ExponentialPortFader(this.mySum.inputB, "CenterFreq", 400.0, 50.0, 20000.0));
            this.scope = new SynthScope();
            this.scope.createProbe(this.myOsc.output, "Osc", Color.yellow);
            this.scope.createProbe(this.myOscBL.output, "OscBL", Color.cyan);
            this.scope.createProbe(this.myLFO.output, "LFO", Color.red);
            this.scope.createProbe(this.mySum.output, "Freq", Color.green);
            this.scope.finish();
            this.scope.show();
            this.dialog = new Dialog((Frame)this.getParent(), "JSyn Scope", false);
            this.dialog.resize(600, 600);
            this.dialog.add(this.scope);
            this.dialog.show();
            int time = Synth.getTickCount() + (int)(Synth.getTickRate() * 0.5);
            this.myOut.start(time);
            this.myOsc.start(time);
            this.myOscBL.start(time);
            this.mySum.start(time);
            this.myLFO.start(time);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.myOsc.delete();
            this.myOsc = null;
            this.myLFO.delete();
            this.myLFO = null;
            this.mySum.delete();
            this.mySum = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

