/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SawtoothOscillatorDPW;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view11x.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;

public class TJ_SawFader
extends Applet {
    SawtoothOscillatorDPW osc;
    LineOut lineOut;
    TriangleOscillator lfo;
    AddUnit adder;
    ExponentialLag myLag;
    PanUnit myPanner;
    Button ping;

    public static void main(String[] args) {
        TJ_SawFader applet = new TJ_SawFader();
        AppletFrame frame = new AppletFrame("Test Java Synthesis", applet);
        frame.resize(600, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.getVersion();
        }
        catch (Throwable thr) {
            this.add(new Label("To run this Applet, you need the JSyn Plugin from: "));
            this.add(new Label("http://www.softsynth.com/jsyn/plugins/"));
            return;
        }
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.setTrace(0);
            Synth.startEngine(0);
            this.osc = new SawtoothOscillatorDPW();
            this.lfo = new TriangleOscillator();
            this.adder = new AddUnit();
            this.myLag = new ExponentialLag();
            this.myPanner = new PanUnit();
            this.lineOut = new LineOut();
            this.myLag.output.connect(this.adder.inputB);
            this.lfo.output.connect(this.adder.inputA);
            this.adder.output.connect(this.osc.frequency);
            this.osc.output.connect(this.myPanner.input);
            this.myPanner.output.connect(0, this.lineOut.input, 0);
            this.myPanner.output.connect(1, this.lineOut.input, 1);
            this.add(new PortFader(this.osc.amplitude, 0.5, 0.0, 0.999));
            this.add(new PortFader(this.lfo.frequency, "ModRate", 0.2, 0.0, 20.0));
            this.add(new PortFader(this.lfo.amplitude, "ModDepth", 400.0, 0.0, 2000.0));
            this.add(new PortFader(this.myLag.input, "CenterFreq", 200.0, 0.0, 2000.0));
            this.add(new PortFader(this.myPanner.pan, 0.0, -1.0, 1.0));
            this.add(new PortFader(this.myLag.halfLife, 0.1, 0.0, 1.0));
            this.ping = new Button("Ping");
            this.add(this.ping);
            this.lineOut.start();
            this.osc.start();
            this.adder.start();
            this.myLag.start();
            this.myPanner.start();
            this.lfo.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.osc.stop();
            this.lineOut.stop();
            this.adder.stop();
            this.myLag.stop();
            this.osc.delete();
            this.lineOut.delete();
            this.lfo.delete();
            this.adder.delete();
            this.myLag.delete();
            this.osc = null;
            this.lineOut = null;
            this.lfo = null;
            this.adder = null;
            this.myLag = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.ping) {
                this.myLag.current.set(2000.0);
                return true;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
        return false;
    }
}

