/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view11x.DecibelPortFader;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.tools.jsyn.CheckForJSyn;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;

public class TJ_SawFader2
extends Applet {
    SawtoothOscillatorBL osc;
    LineOut lineOut;
    TriangleOscillator lfo;
    AddUnit adder;
    ExponentialLag myLag;
    PanUnit myPanner;
    Button ping;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_SawFader2 applet = new TJ_SawFader2();
        AppletFrame frame = new AppletFrame("Test Java Synthesis", applet);
        frame.resize(600, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        int jsynStatus = CheckForJSyn.getStatus();
        if (jsynStatus != 0) {
            this.setLayout(new BorderLayout());
            this.add("Center", new CheckForJSyn(this).setupGUI(jsynStatus));
            this.getParent().validate();
            this.getToolkit().sync();
            return;
        }
        this.setLayout(new GridLayout(0, 1));
        try {
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.osc = new SawtoothOscillatorBL(this.synthContext);
            this.lfo = new TriangleOscillator(this.synthContext);
            this.adder = new AddUnit(this.synthContext);
            this.myLag = new ExponentialLag(this.synthContext);
            this.myPanner = new PanUnit(this.synthContext);
            this.lineOut = new LineOut(this.synthContext);
            this.myLag.output.connect(this.adder.inputB);
            this.lfo.output.connect(this.adder.inputA);
            this.adder.output.connect(this.osc.frequency);
            this.osc.output.connect(this.myPanner.input);
            this.myPanner.output.connect(0, this.lineOut.input, 0);
            this.myPanner.output.connect(1, this.lineOut.input, 1);
            this.add(new DecibelPortFader(this.osc.amplitude, "Volume (dB)", -3.0, -60.0, 0.0));
            this.add(new ExponentialPortFader(this.lfo.frequency, "ModRate (Hz)", 0.2, 0.1, 20.0));
            this.add(new ExponentialPortFader(this.lfo.amplitude, "ModDepth (Hz)", 100.0, 0.01, 1000.0));
            PortFader pitchFader = new PortFader(this.myLag.input, "CenterFreq (Semitones)", 60.0, 21.0, 108.0){

                @Override
                public void tweak(int idx, double fval) {
                    double freq = EqualTemperedTuning.getMIDIFrequency(fval);
                    if (this.getPort() != null) {
                        this.getPort().set(freq);
                    }
                }
            };
            this.add(pitchFader);
            this.add(new PortFader(this.myPanner.pan, 0.0, -1.0, 1.0));
            this.add(new ExponentialPortFader(this.myLag.halfLife, 0.1, 0.002, 1.0));
            this.ping = new Button("Ping");
            this.add(this.ping);
            this.lineOut.start();
            this.osc.start();
            this.adder.start();
            this.myLag.start();
            this.myPanner.start();
            this.lfo.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.osc.delete();
            this.lineOut.delete();
            this.lfo.delete();
            this.adder.delete();
            this.myLag.delete();
            this.osc = null;
            this.lineOut = null;
            this.lfo = null;
            this.adder = null;
            this.myLag = null;
            this.removeAll();
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (NullPointerException e) {
            System.err.println(e);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.ping) {
                this.myLag.current.set(2000.0);
                return true;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
        return false;
    }
}

