/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.examples.perfrack.RecursiveSequence;
import com.softsynth.jsyn.examples.perfrack.SimpleRackUnit;
import com.softsynth.jsyn.view102.BarGraphEditor;
import com.softsynth.jsyn.view102.CustomFader;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

class RecursiveMelodyRackUnit
extends SimpleRackUnit {
    Panel panel;
    FilteredSawtoothBL sawIns;
    BarGraphEditor freqEditor;
    double[] freqData;
    CustomFader densityBar;
    CustomFader stretchBar;
    RecursiveSequence rSeq;
    EqualTemperedTuning NTET;
    Choice ntetChoice;
    Label ntetLabel;
    Button ntetButton;
    static double[] ampls = new double[]{0.4, 0.2, 0.3, 0.2};

    public RecursiveMelodyRackUnit() {
        this.setName("Recursive Melody");
        try {
            this.sawIns = new FilteredSawtoothBL();
            this.unitNote = this.sawIns;
            this.unitNote.amplitude.set(0.5);
        }
        catch (SynthException e) {
            System.err.println("Error in RecursiveMelodyRackUnit" + e);
            return;
        }
        this.rSeq = new RecursiveSequence(21, 5, 20);
        this.NTET = new EqualTemperedTuning(200.0);
        this.numRackUnits = 1;
        this.setLayout(new GridLayout(0, 2));
        Panel densityPanel = new Panel();
        this.add(densityPanel);
        densityPanel.setLayout(new GridLayout(0, 2));
        densityPanel.add(new Label("Note Density ", 2));
        this.densityBar = new CustomFader(0, 75, 1, 0, 100);
        densityPanel.add(this.densityBar);
        Panel ntetPanel = new Panel();
        this.add(ntetPanel);
        this.ntetChoice = new Choice();
        ntetPanel.add(this.ntetChoice);
        this.ntetChoice.addItem(Integer.toString(5));
        this.ntetChoice.addItem(Integer.toString(7));
        this.ntetChoice.addItem(Integer.toString(9));
        this.ntetChoice.addItem(Integer.toString(12));
        this.ntetChoice.addItem(Integer.toString(17));
        this.ntetChoice.addItem(Integer.toString(19));
        this.ntetChoice.addItem(Integer.toString(24));
        this.ntetChoice.addItem(Integer.toString(31));
        this.ntetButton = new Button("Set Notes/Octave");
        ntetPanel.add(this.ntetButton);
        this.ntetLabel = new Label();
        ntetPanel.add(this.ntetLabel);
        this.setEqualTemper(7);
        Panel stretchPanel = new Panel();
        this.add(stretchPanel);
        stretchPanel.setLayout(new GridLayout(0, 2));
        stretchPanel.add(new Label("Max Interval ", 2));
        this.stretchBar = new CustomFader(0, 7, 1, 1, 20);
        stretchPanel.add(this.stretchBar);
    }

    void setEqualTemper(int N) {
        this.NTET.setNotesPerOctave(N);
        this.rSeq.setMaxValue(N * 3);
        this.ntetLabel.setText(String.valueOf(Integer.toString(N)) + " Notes/Octave");
    }

    @Override
    public void beat(int time, int duration, int beatIndex) throws SynthException {
        this.rSeq.setDensity((double)this.densityBar.getValue() / 100.0);
        this.rSeq.setMaxInterval(this.stretchBar.getValue());
        int pitch = this.rSeq.next(beatIndex);
        if (pitch >= 0) {
            double amplitude = ampls[beatIndex % ampls.length];
            this.sawIns.note(time, duration, this.NTET.getFrequency(pitch), amplitude);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.ntetButton) {
            int n = Integer.parseInt(this.ntetChoice.getSelectedItem());
            this.setEqualTemper(n);
            return true;
        }
        return false;
    }
}

