/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import java.applet.Applet;

public class QA_Allocator
extends Applet {
    BussedVoiceAllocator allocator;
    LineOut lineOut;
    int numErrors = 0;

    public static void main(String[] args) {
        QA_Allocator app = new QA_Allocator();
        app.test();
    }

    void test() {
        try {
            Synth.startEngine(0);
            this.lineOut = new LineOut();
            this.allocator = new BussedVoiceAllocator(2){

                @Override
                public SynthCircuit makeVoice() {
                    FilteredSawtoothBL circ = new FilteredSawtoothBL();
                    return this.addVoiceToMix(circ);
                }
            };
            this.allocator.output.connect(0, this.lineOut.input, 0);
            this.allocator.output.connect(0, this.lineOut.input, 1);
            this.lineOut.start();
            int time = Synth.getTickCount() + 100;
            int second = (int)Synth.getTickRate();
            int duration = 5 * second;
            SynthNote note1 = (SynthNote)this.allocator.steal(time, time + duration);
            note1.noteOnFor(time, duration, 300.0, 0.5);
            duration = 1 * second;
            SynthNote note2 = (SynthNote)this.allocator.steal(time, time + duration);
            note2.noteOnFor(time, duration, 400.0, 0.5);
            duration = 2 * second;
            SynthNote note3 = (SynthNote)this.allocator.steal(time += 3 * second, time + duration);
            note3.noteOnFor(time, duration, 500.0, 0.5);
            time += duration;
            if (note2 != note3) {
                this.reportError("Allocator should have allocated same voice as note2!");
            }
            Synth.sleepUntilTick(time + second);
            Synth.stopEngine();
            System.out.println("NumErrors = " + this.numErrors);
        }
        catch (SynthException e) {
            SynthAlert.showError(e);
        }
    }

    void reportError(String msg) {
        System.err.println(msg);
        ++this.numErrors;
    }
}

