/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleQueue;

public abstract class SampleQueueStream {
    SynthSampleQueue queue;
    SynthSample sample;
    int frameCount = 0;
    int frameIndex = 0;
    private int lastFramesBackground = 0;
    int startTime;
    boolean running = false;
    boolean flowError = false;
    int maxTicksPerSleep;
    SynthContext synthContext = null;

    public SampleQueueStream(SynthSampleQueue queue, int bufferSizeInFrames, int channelsPerFrame) {
        this.queue = queue;
        this.synthContext = queue.getSound().getSynthContext();
        this.lastFramesBackground = queue.getNumFramesMoved();
        this.sample = new SynthSample(this.synthContext, bufferSizeInFrames, channelsPerFrame);
        int ticksPerBuffer = bufferSizeInFrames / (2 * this.synthContext.getFramesPerTick());
        this.maxTicksPerSleep = ticksPerBuffer / 8;
        if (this.maxTicksPerSleep < 1) {
            this.maxTicksPerSleep = 1;
        }
        if (this.maxTicksPerSleep < 64) {
            this.maxTicksPerSleep = ticksPerBuffer / 4;
        }
        if (this.maxTicksPerSleep < 64) {
            this.maxTicksPerSleep = ticksPerBuffer / 2;
        }
    }

    public SynthSample getSample() {
        return this.sample;
    }

    public void start(int time) {
        this.startTime = time;
        this.running = true;
        this.flowError = false;
    }

    public void stop(int time) {
        this.running = false;
        this.frameCount = 0;
    }

    public synchronized int available() {
        int moved = this.queue.getNumFramesMoved();
        int backDelta = moved - this.lastFramesBackground;
        this.lastFramesBackground = moved;
        this.frameCount -= backDelta;
        int available = this.calcAvailable(this.frameCount);
        if (available < 0) {
            available = 0;
        } else if (available > this.sample.getNumFrames()) {
            this.flowError = true;
            available = this.sample.getNumFrames();
        }
        return available;
    }

    public int move(short[] data, int offset, int numFrames) {
        int framesLeft = numFrames;
        while (framesLeft > 0) {
            int available = this.available();
            if (available > 0) {
                int numToMove = framesLeft > available ? available : framesLeft;
                this.frameCount += this.moveNow(data, offset, numToMove);
                offset += numToMove * this.sample.getChannelsPerFrame();
                framesLeft -= numToMove;
            }
            if (framesLeft <= 0) continue;
            if (!this.running) {
                return numFrames - framesLeft;
            }
            int ticksToSleep = framesLeft / this.synthContext.getFramesPerTick();
            if (ticksToSleep > this.maxTicksPerSleep) {
                ticksToSleep = this.maxTicksPerSleep;
            } else if (ticksToSleep < 1) {
                ticksToSleep = 1;
            }
            this.synthContext.sleepForTicks(ticksToSleep);
        }
        return numFrames;
    }

    synchronized int moveNow(short[] data, int offset, int numFrames) {
        if (this.frameIndex + numFrames <= this.sample.getNumFrames()) {
            this.moveDirect(this.frameIndex, data, offset, numFrames);
            this.queue.queue(this.sample, this.frameIndex, numFrames);
            this.frameIndex += numFrames;
            if (this.frameIndex >= this.sample.getNumFrames()) {
                this.frameIndex -= this.sample.getNumFrames();
            }
        } else {
            int firstNum = this.sample.getNumFrames() - this.frameIndex;
            this.moveDirect(this.frameIndex, data, offset, firstNum);
            this.queue.queue(this.sample, this.frameIndex, firstNum);
            int secondNum = numFrames - firstNum;
            this.moveDirect(0, data, offset += firstNum * this.sample.getChannelsPerFrame(), secondNum);
            this.queue.queue(this.sample, 0, secondNum);
            this.frameIndex = secondNum;
        }
        return numFrames;
    }

    synchronized boolean checkAndClearFlowError() {
        boolean result = this.flowError;
        this.flowError = false;
        return result;
    }

    abstract void moveDirect(int var1, short[] var2, int var3, int var4);

    abstract int calcAvailable(int var1);
}

