/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SampleWriter;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.util.SampleQueueInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamRecorder
extends FilterOutputStream
implements Runnable {
    public SynthInput input;
    SynthContext synthContext;
    SampleWriter sampler;
    SampleQueueInputStream audioStream;
    boolean isLittleEndian = true;
    byte[] buffer;
    short[] samples;
    Thread thread;
    boolean go = false;
    boolean done = false;
    int channelsPerFrame = 1;
    int framesPerBuffer;

    public StreamRecorder(OutputStream outStream, int framesPerBuffer, int numBuffers, int channelsPerFrame) {
        this(Synth.getSharedContext(), outStream, framesPerBuffer, numBuffers, channelsPerFrame);
    }

    public StreamRecorder(SynthContext synthContext, OutputStream outStream, int framesPerBuffer, int numBuffers, int channelsPerFrame) {
        super(outStream);
        this.synthContext = synthContext;
        if (channelsPerFrame == 1) {
            this.sampler = new SampleWriter_16F1(synthContext);
        } else if (channelsPerFrame == 2) {
            this.sampler = new SampleWriter_16F2(synthContext);
        } else {
            throw new RuntimeException("channelsPerFrame must be 1 or 2");
        }
        this.input = this.sampler.input;
        if (numBuffers < 2) {
            numBuffers = 2;
        }
        this.audioStream = new SampleQueueInputStream(this.sampler.samplePort, framesPerBuffer * numBuffers, channelsPerFrame);
        int bytesPerBuffer = framesPerBuffer * channelsPerFrame * 2;
        this.buffer = new byte[bytesPerBuffer];
        this.samples = new short[bytesPerBuffer / 2];
        this.channelsPerFrame = channelsPerFrame;
        this.framesPerBuffer = framesPerBuffer;
    }

    public void setLittleEndianness(boolean isLittleEndian) {
        this.isLittleEndian = isLittleEndian;
    }

    public boolean getLittleEndianness() {
        return this.isLittleEndian;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void transfer() throws IOException {
        this.audioStream.read(this.samples, 0, this.framesPerBuffer);
        int bindex = 0;
        if (this.isLittleEndian) {
            int i = 0;
            while (i < this.samples.length) {
                this.buffer[bindex++] = (byte)this.samples[i];
                this.buffer[bindex++] = (byte)(this.samples[i] >> 8);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.samples.length) {
                this.buffer[bindex++] = (byte)(this.samples[i] >> 8);
                this.buffer[bindex++] = (byte)this.samples[i];
                ++i;
            }
        }
        this.write(this.buffer);
    }

    @Override
    public void run() {
        try {
            while (this.go) {
                this.transfer();
            }
            this.flush();
        }
        catch (IOException e) {
            System.out.println("StreamRecorder.run() caught " + e);
            e.printStackTrace();
        }
        catch (SynthException e) {
            System.out.println("StreamRecorder.run() caught " + e);
        }
        this.done = true;
    }

    public void start(int time) {
        if (this.thread != null) {
            this.stop(time);
        }
        this.audioStream.start(time);
        this.sampler.start(time);
        this.thread = new Thread(this);
        this.go = true;
        this.done = false;
        this.thread.start();
    }

    public void stop(int time) {
        int tickDelay = 32;
        int timeout = (int)(this.synthContext.getTickRate() * 5.0 / (double)tickDelay);
        this.go = false;
        this.thread.interrupt();
        while (!this.done && timeout-- > 0) {
            this.synthContext.sleepForTicks(tickDelay);
        }
        if (timeout <= 0) {
            System.out.println("StreamRecorder.stop() - timeout = " + timeout);
        }
        this.audioStream.stop(time);
        this.sampler.stop(time);
        this.thread = null;
    }
}

