/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view11x;

import com.softsynth.jsyn.view11x.Tweakable;
import com.softsynth.view.CustomFader;
import com.softsynth.view.CustomFaderDouble;
import com.softsynth.view.CustomFaderListener;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class LabelledFader
extends Panel
implements CustomFaderListener,
Tweakable {
    Tweakable target;
    int targetIndex;
    String faderName;
    Label nameLabel;
    Label valueLabel;
    protected CustomFaderDouble fader;

    public LabelledFader(Tweakable target, int targetIndex, String faderName, double startValue, double min, double max) {
        this.target = target == null ? this : target;
        this.targetIndex = targetIndex;
        this.faderName = faderName;
        this.setLayout(new GridLayout(0, 3));
        this.nameLabel = new Label(String.valueOf(faderName) + " ", 2);
        this.add(this.nameLabel);
        if (startValue < min) {
            startValue = min;
        } else if (startValue > max) {
            startValue = max;
        }
        this.fader = new CustomFaderDouble(0, startValue, min, max);
        this.fader.addCustomFaderListener(this);
        this.add(this.fader);
        this.valueLabel = new Label();
        this.showValue(startValue);
        this.add(this.valueLabel);
    }

    public double getMinimum() {
        return this.fader.getMinimum();
    }

    public double getMaximum() {
        return this.fader.getMaximum();
    }

    void showValue(double fval) {
        String fvalString = Double.toString(fval);
        int maxchars = fvalString.indexOf(46) + 5;
        String actualString = fvalString.length() > maxchars ? fvalString.substring(0, maxchars) : fvalString;
        this.valueLabel.setText(actualString);
    }

    public CustomFaderDouble getFader() {
        return this.fader;
    }

    public void setValue(double fval) {
        this.fader.setValue(fval);
    }

    @Override
    public void tweak(int idx, double fval) {
    }

    @Override
    public void customFaderValueChanged(CustomFader fdr, int value) {
        CustomFaderDouble fdbl = (CustomFaderDouble)fdr;
        double fval = fdbl.faderToDouble(value);
        this.target.tweak(this.targetIndex, fval);
        this.showValue(fval);
    }
}

