/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreInstrument;

public class ScoreRest
extends ScoreElement {
    protected double duration = 1.0;

    public ScoreRest() {
    }

    public ScoreRest(double duration) {
        this.duration = duration;
    }

    @Override
    public ScoreElementPlayer start(ScoreElementPlayer parentPlayer, double time) {
        ScoreRestPlayer player = new ScoreRestPlayer(this, parentPlayer);
        player.start(time);
        return player;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", duration = " + this.duration;
    }

    protected static class ScoreRestPlayer
    extends ScoreElementPlayer {
        private double lastTime;
        private double endTime;

        private ScoreRestPlayer(ScoreElement scoreRest, ScoreElementPlayer parentPlayer) {
            super(scoreRest, parentPlayer);
        }

        @Override
        public void start(double time) {
            super.start(time);
            ScoreInstrument instrument = this.getInstrument();
            if (instrument != null) {
                instrument.play(this.getElement(), time, this.getAmplitude());
            }
            this.lastTime = time;
            this.endTime = time + ((ScoreRest)this.getElement()).getDuration();
        }

        @Override
        public double advance(double time) {
            this.lastTime = time;
            return this.endTime;
        }

        @Override
        public boolean isDone() {
            return this.lastTime >= this.endTime;
        }
    }
}

