/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class FindJSynNative {
    public static void main(String[] args) {
        System.out.println("=====================================");
        System.out.println("java.library.path = " + System.getProperty("java.library.path"));
        System.out.println("=====================================");
        FindJSynNative finder = new FindJSynNative();
        finder.findNativeLibrary(System.mapLibraryName("JSynV142"));
    }

    Vector splitString(String text, char separator) {
        int index;
        Vector<String> strings = new Vector<String>();
        int last = 0;
        while ((index = text.indexOf(separator, last)) >= 0) {
            String temp = text.substring(last, index);
            strings.addElement(temp);
            last = index + 1;
        }
        return strings;
    }

    void findNativeLibrary(String libraryFileName) {
        try {
            String path = System.getProperty("java.library.path");
            if (path != null) {
                Vector strings = this.splitString(path, File.pathSeparatorChar);
                Enumeration enumer = strings.elements();
                while (enumer.hasMoreElements()) {
                    String dirName = (String)enumer.nextElement();
                    String libPathName = String.valueOf(dirName) + File.separator + libraryFileName;
                    File libFile = new File(libPathName);
                    if (!libFile.exists()) continue;
                    System.out.println("Library found at: " + libPathName);
                }
            }
        }
        catch (SecurityException e) {
            System.out.println(e + " accessing java.library.path");
        }
    }
}

