/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.view;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

class XYFader
extends Canvas
implements MouseMotionListener {
    boolean circleDrawn = false;
    int lastCircleX;
    int lastCircleY;
    int lastCircleDiameter;

    public XYFader() {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseMotionListener(this);
    }

    void trackMotion(MouseEvent e) {
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        g.setColor(Color.blue);
        if (this.circleDrawn) {
            g.fillOval(this.lastCircleX, this.lastCircleY, this.lastCircleDiameter, this.lastCircleDiameter);
        }
        this.lastCircleDiameter = 20;
        int lastRadius = this.lastCircleDiameter / 2;
        this.lastCircleX = e.getX() - lastRadius;
        this.lastCircleY = e.getY() - lastRadius;
        g.fillOval(this.lastCircleX, this.lastCircleY, this.lastCircleDiameter, this.lastCircleDiameter);
        this.circleDrawn = true;
        g.setPaintMode();
    }

    void useMotion(MouseEvent e) {
        double xVal = (double)e.getX() / (double)this.bounds().width;
        double yVal = 1.0 - (double)e.getY() / (double)this.bounds().height;
        this.faderMoved(xVal, yVal);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.circleDrawn = false;
    }

    public void faderMoved(double xVal, double yVal) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.trackMotion(e);
        this.useMotion(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

