/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import java.io.File;
import java.io.FilenameFilter;

class WildcardFilenameFilter
implements FilenameFilter {
    String pattern;

    public WildcardFilenameFilter(String pattern) {
        this.pattern = pattern;
    }

    static boolean wildMatch(String pattern, String candidate) {
        int starPos = pattern.indexOf(42);
        if (starPos < 0) {
            return pattern.equalsIgnoreCase(candidate);
        }
        if (starPos > 0) {
            if (pattern.regionMatches(true, 0, candidate, 0, starPos)) {
                return WildcardFilenameFilter.wildMatch(pattern.substring(starPos), candidate.substring(starPos));
            }
            return false;
        }
        if (pattern.regionMatches(true, 1, candidate, 0, candidate.length())) {
            return true;
        }
        int i = 0;
        while (i < candidate.length()) {
            if (WildcardFilenameFilter.wildMatch(pattern.substring(1), candidate.substring(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name) {
        return WildcardFilenameFilter.wildMatch(this.pattern, name);
    }
}

