/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.view;

import com.softsynth.view.CustomFader;
import com.softsynth.view.ValueController;
import com.softsynth.view.ValueEvent;
import com.softsynth.view.ValueListener;
import java.util.Enumeration;
import java.util.Vector;

public class CustomFaderDouble
extends CustomFader
implements ValueController {
    public static final int LINEAR = 0;
    public static final int EXPONENTIAL = 1;
    int taper = 0;
    double logMax;
    double logMin;
    double min;
    double max;
    protected static final int RANGE = 2000;
    Vector valueListeners = new Vector();
    ValueEvent event = new ValueEvent(this);

    public CustomFaderDouble(int orientation, double initialValue, double min, double max) {
        super(orientation, 0, 100, 0, 2000);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(initialValue);
        this.setUnitIncrement(20);
    }

    @Override
    void tellListeners() {
        super.tellListeners();
        if (this.valueListeners == null) {
            return;
        }
        Enumeration e = this.valueListeners.elements();
        this.event.setValue(this.getDoubleValue());
        while (e.hasMoreElements()) {
            ValueListener listener = (ValueListener)e.nextElement();
            listener.valueChanged(this.event);
        }
    }

    @Override
    public void addValueListener(ValueListener listener) {
        this.valueListeners.addElement(listener);
    }

    @Override
    public void removeValueListener(ValueListener listener) {
        this.valueListeners.removeElement(listener);
    }

    public void setTaper(int taper) {
        double curValue = this.faderToDouble(this.value);
        this.taper = taper;
        this.setMinimum(this.min);
        this.setMaximum(this.max);
        this.setValue(curValue);
    }

    public int getTaper() {
        return this.taper;
    }

    public double faderToDouble(int val) {
        double result = 0.0;
        double frac = (double)val / 2000.0;
        switch (this.taper) {
            case 0: {
                result = frac * (this.max - this.min) + this.min;
                break;
            }
            case 1: {
                double exp = frac * (this.logMax - this.logMin);
                result = this.min * Math.exp(exp);
            }
        }
        return result;
    }

    public int doubleToFader(double val) {
        double frac = 0.0;
        switch (this.taper) {
            case 0: {
                frac = (val - this.min) / (this.max - this.min);
                break;
            }
            case 1: {
                frac = (Math.log(val) - this.logMin) / (this.logMax - this.logMin);
            }
        }
        int result = (int)(frac * 2000.0);
        return result;
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public void setMinimum(double min) {
        if (this.taper == 1 && min < 1.0E-7) {
            min = 1.0E-7;
        }
        this.min = min;
        this.logMin = Math.log(min);
    }

    @Override
    public void setMaximum(double max) {
        this.max = max;
        this.logMax = Math.log(max);
    }

    @Override
    public void setValue(double fval) {
        int ival = this.doubleToFader(fval);
        super.setValue(ival);
    }

    @Override
    public double getDoubleValue() {
        return this.faderToDouble(this.getValue());
    }
}

