/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.Module;
import com.softsynth.wire.Patch;
import com.softsynth.wire.RecursiveLoader;
import java.awt.Rectangle;
import java.util.Hashtable;

abstract class ModuleLoader
extends RecursiveLoader {
    Patch patch;
    LoaderContext ldcon;
    String name = null;
    String type = null;
    int x = 30;
    int y = 30;
    int width = 0;
    int height = 0;
    double parameter;
    Module currentModule;
    Rectangle editorBounds;

    public ModuleLoader(String tag, LoaderContext ldcon) {
        super(tag);
        this.patch = ldcon.patch;
        this.ldcon = ldcon;
    }

    @Override
    void handleAttributes(Hashtable attributes) {
        this.name = (String)attributes.get("name");
        String newName = this.patch.makeNameUnique(this.name);
        if (this.name != newName) {
            this.ldcon.nameRemapper.put(this.name, newName);
            this.name = newName;
        }
        this.type = (String)attributes.get("type");
        this.x = this.getAttribute(attributes, "xpos", 30);
        this.y = this.getAttribute(attributes, "ypos", 30);
        this.width = this.getAttribute(attributes, "width", 100);
        this.height = this.getAttribute(attributes, "height", 100);
        this.parameter = this.getAttribute(attributes, "param", 1.0);
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("editor")) {
            this.editorBounds = this.handleEditorAttributes(attributes);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    @Override
    public void handleEndElement() {
        if (this.currentModule != null && this.editorBounds != null) {
            this.currentModule.setEditorBounds(this.editorBounds);
        }
        super.handleEndElement();
    }

    void setupModule(Patch patch) {
        Module module = this.makeModule(patch);
        if (module == null) {
            throw new RuntimeException("couldn't load unit" + this.type);
        }
        module.setLocation(this.x, this.y);
        this.currentModule = module;
        if (this.ldcon.selectWhenLoaded) {
            patch.selectModule(module);
        }
    }

    abstract Module makeModule(Patch var1);
}

