/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.tools.view.JTextFieldDouble;
import com.softsynth.wire.Module;
import com.softsynth.wire.NumericRootModule;
import com.softsynth.wire.NumericTextJack;
import com.softsynth.wire.WireRangeEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class NumericTextModule
extends NumericRootModule
implements ActionListener {
    NumericTextJack textPort;
    JTextFieldDouble textField;

    void setText(String valueText) {
        this.textField.setText(valueText);
    }

    String getText() {
        return this.textField.getText();
    }

    @Override
    public void setupJacks() {
        this.textPort = new NumericTextJack((Module)this, 0.0, 6);
        this.textPort.setName("text");
        this.addJack(this.textPort);
        this.textField = (JTextFieldDouble)this.textPort.getComponent();
        this.panel.add((Component)this.textField, "Center");
        this.textField.addActionListener(this);
        this.setupConnectorPort();
    }

    @Override
    void sendValue() {
        this.setOutPort(this.textPort.get());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            this.textPort.set(this.textField.getValue());
            this.sendValue();
            this.getPatch().setModified(true);
        }
        catch (NumberFormatException e) {
            this.textField.setText("Error!");
            this.textField.selectAll();
        }
    }

    @Override
    boolean edit() {
        WireRangeEditor editor = new WireRangeEditor(this.patch.getPatchPanel().getFrame(), this, this.textPort);
        if (this.editorBounds != null) {
            editor.setBounds(this.editorBounds);
        }
        boolean result = editor.ask() == 1;
        this.editorBounds = editor.getBounds();
        if (result) {
            this.sendValue();
        }
        return result;
    }

    @Override
    boolean editAfterMake() {
        return this.edit();
    }
}

